/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import robaho.net.httpserver.ServerConfig;

class Request {
    static final int BUF_LEN = 2048;
    static final byte CR = 13;
    static final byte LF = 10;
    private String startLine;
    private InputStream is;
    private OutputStream os;
    char[] buf = new char[2048];
    int pos;
    StringBuffer lineBuf;
    Headers hdrs = null;

    Request(InputStream rawInputStream, OutputStream rawout) throws IOException {
        this.is = rawInputStream;
        this.os = rawout;
        do {
            this.startLine = this.readLine();
        } while ("".equals(this.startLine));
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    public String readLine() throws IOException {
        boolean gotCR = false;
        boolean gotLF = false;
        this.pos = 0;
        this.lineBuf = new StringBuffer();
        while (!gotLF) {
            int c;
            try {
                c = this.is.read();
            }
            catch (IOException e) {
                if (this.pos == 0) {
                    return null;
                }
                throw e;
            }
            if (c == -1) {
                return null;
            }
            if (gotCR) {
                if (c == 10) {
                    gotLF = true;
                    continue;
                }
                gotCR = false;
                this.consume(13);
                this.consume(c);
                continue;
            }
            if (c == 13) {
                gotCR = true;
                continue;
            }
            this.consume(c);
        }
        this.lineBuf.append(this.buf, 0, this.pos);
        return new String(this.lineBuf);
    }

    private void consume(int c) {
        if (this.pos == 2048) {
            this.lineBuf.append(this.buf);
            this.pos = 0;
        }
        this.buf[this.pos++] = (char)c;
    }

    public String requestLine() {
        return this.startLine;
    }

    /*
     * Enabled aggressive block sorting
     */
    Headers headers() throws IOException {
        if (this.hdrs != null) {
            return this.hdrs;
        }
        this.hdrs = new Headers();
        char[] s = new char[10];
        int len = 0;
        int firstc = this.is.read();
        if (firstc == 13 || firstc == 10) {
            int c = this.is.read();
            if (c == 13 || c == 10) {
                return this.hdrs;
            }
            s[0] = (char)firstc;
            len = 1;
            firstc = c;
        }
        while (true) {
            String k;
            int keyend;
            block24: {
                int c;
                boolean inKey;
                if (firstc != 10 && firstc != 13 && firstc >= 0) {
                    keyend = -1;
                    inKey = firstc > 32;
                    s[len++] = (char)firstc;
                } else {
                    return this.hdrs;
                }
                while ((c = this.is.read()) >= 0) {
                    switch (c) {
                        case 58: {
                            if (inKey && len > 0) {
                                keyend = len;
                            }
                            inKey = false;
                            break;
                        }
                        case 9: {
                            c = 32;
                        }
                        case 32: {
                            inKey = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            firstc = this.is.read();
                            if (c == 13 && firstc == 10 && (firstc = this.is.read()) == 13) {
                                firstc = this.is.read();
                            }
                            if (firstc == 10 || firstc == 13 || firstc > 32) break block24;
                            c = 32;
                        }
                    }
                    if (len >= s.length) {
                        char[] ns = new char[s.length * 2];
                        System.arraycopy(s, 0, ns, 0, len);
                        s = ns;
                    }
                    s[len++] = (char)c;
                }
                firstc = -1;
            }
            while (len > 0 && s[len - 1] <= ' ') {
                --len;
            }
            if (keyend <= 0) {
                k = null;
                keyend = 0;
            } else {
                k = String.copyValueOf(s, 0, keyend);
                if (keyend < len && s[keyend] == ':') {
                    ++keyend;
                }
                while (keyend < len && s[keyend] <= ' ') {
                    ++keyend;
                }
            }
            String v = keyend >= len ? new String() : String.copyValueOf(s, keyend, len - keyend);
            if (this.hdrs.size() >= ServerConfig.getMaxReqHeaders()) {
                throw new IOException("maximum number of headers exceeded");
            }
            if (k == null) {
                k = "";
            }
            this.hdrs.add(k, v);
            len = 0;
        }
    }
}

