/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver.extras;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProxyHandler
implements HttpHandler {
    private final ConcurrentMap<URI, HostPort> proxies = new ConcurrentHashMap<URI, HostPort>();
    private final HttpClient proxyClient;
    private final Optional<HostPort> defaultProxy;
    private static final Set<String> restrictedHeaders = Set.of("CONNECTION", "HOST", "UPGRADE", "CONTENT-LENGTH");

    public ProxyHandler() {
        this(Optional.empty());
    }

    public ProxyHandler(HostPort defaultProxy) {
        this(Optional.of(defaultProxy));
    }

    private ProxyHandler(Optional<HostPort> defaultProxy) {
        this.defaultProxy = defaultProxy;
        this.proxyClient = HttpClient.newBuilder().proxy(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                HostPort hp = (HostPort)ProxyHandler.this.proxies.get(uri);
                return List.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hp.server, hp.port)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                ProxyHandler.this.connectFailed(uri, sa, ioe);
            }
        }).build();
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        HostPort proxy = this.proxyTo(exchange).orElseThrow(() -> new IOException("proxy not configured for " + String.valueOf(exchange.getRequestURI())));
        URI uri = exchange.getRequestURI();
        if (uri.getScheme() == null) {
            try {
                uri = new URI(proxy.scheme, uri.getUserInfo(), exchange.getLocalAddress().getHostName(), exchange.getLocalAddress().getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new IOException("invalid proxy uri ", ex);
            }
        }
        this.proxies.put(uri, proxy);
        try {
            HttpResponse<InputStream> response = this.proxyClient.send(HttpRequest.newBuilder(uri).headers(ProxyHandler.headers(exchange.getRequestHeaders())).method(exchange.getRequestMethod(), HttpRequest.BodyPublishers.ofInputStream(() -> exchange.getRequestBody())).build(), HttpResponse.BodyHandlers.ofInputStream());
            exchange.getResponseHeaders().putAll((Map<? extends String, ? extends List<String>>)response.headers().map());
            exchange.sendResponseHeaders(response.statusCode(), 0L);
            try (OutputStream os = exchange.getResponseBody();){
                response.body().transferTo(os);
            }
        }
        catch (InterruptedException ex) {
            throw new IOException("unable to proxy request to " + String.valueOf(exchange.getRequestURI()), ex);
        }
    }

    private static String[] headers(Headers headers) {
        ArrayList copy = new ArrayList();
        headers.entrySet().stream().filter(e -> !restrictedHeaders.contains(((String)e.getKey()).toUpperCase())).forEach(e -> ((List)e.getValue()).forEach(v -> {
            copy.add((String)e.getKey());
            copy.add(v);
        }));
        return (String[])copy.toArray(String[]::new);
    }

    protected Optional<HostPort> proxyTo(HttpExchange exchange) {
        return this.defaultProxy;
    }

    protected void connectFailed(URI uri, SocketAddress sa, IOException ieo) {
    }

    public record HostPort(String server, int port, String scheme) {
    }
}

