/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class NoSyncBufferedInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    private InputStream getInIfOpen() throws IOException {
        InputStream input = this.in;
        if (input == null) {
            throw new IOException("Stream closed");
        }
        return input;
    }

    private void ensureOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
    }

    private byte[] getBufIfOpen() throws IOException {
        if (this.buf == null) {
            throw new IOException("Stream closed");
        }
        return this.buf;
    }

    public NoSyncBufferedInputStream(InputStream in) {
        this(in, 8192);
    }

    public NoSyncBufferedInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    private void fill() throws IOException {
        byte[] buffer = this.getBufIfOpen();
        if (this.markpos == -1) {
            this.pos = 0;
        } else if (this.pos >= buffer.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(buffer, this.markpos, buffer, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (buffer.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            }
        }
        this.count = this.pos;
        int n = this.getInIfOpen().read(buffer, this.pos, buffer.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    private int read1(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0) {
            int size = this.getBufIfOpen().length;
            if (len >= size && this.markpos == -1) {
                return this.getInIfOpen().read(b, off, len);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0) {
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.getBufIfOpen(), this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        InputStream input;
        this.ensureOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            int nread;
            if ((nread = this.read1(b, off + n, len - n)) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while ((input = this.in) == null || input.available() > 0);
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            if (this.markpos == -1) {
                return this.getInIfOpen().skip(n);
            }
            this.fill();
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return 0L;
            }
        }
        long skipped = avail < n ? avail : n;
        this.pos += (int)skipped;
        return skipped;
    }

    @Override
    public int available() throws IOException {
        int n = this.count - this.pos;
        int avail = this.getInIfOpen().available();
        return n > Integer.MAX_VALUE - avail ? Integer.MAX_VALUE : n + avail;
    }

    @Override
    public void mark(int readlimit) {
        this.marklimit = readlimit;
        this.markpos = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.buf = null;
            super.close();
        }
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        int avail = this.count - this.pos;
        if (avail > 0) {
            byte[] buffer = Arrays.copyOfRange(this.getBufIfOpen(), this.pos, this.count);
            out.write(buffer, this.pos, this.count - this.pos);
            this.pos = this.count;
        }
        return super.transferTo(out);
    }
}

