/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Request {
    static final char CR = '\r';
    static final char LF = '\n';
    private String startLine;
    private final InputStream is;
    private final OutputStream os;
    Headers hdrs = null;

    Request(InputStream rawInputStream, OutputStream rawout) throws IOException {
        this.is = rawInputStream;
        this.os = rawout;
        do {
            this.startLine = this.readLine();
        } while ("".equals(this.startLine));
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    private String readLine() throws IOException {
        StringBuilder lineBuf = new StringBuilder();
        boolean gotCR = false;
        while (true) {
            int c;
            try {
                c = this.is.read();
            }
            catch (IOException e) {
                if (lineBuf.length() == 0) {
                    return null;
                }
                throw e;
            }
            if (c == -1) {
                return null;
            }
            if (gotCR) {
                if (c == 10) {
                    return new String(lineBuf);
                }
                gotCR = false;
                lineBuf.append('\r');
                lineBuf.append((char)c);
                continue;
            }
            if (c == 13) {
                gotCR = true;
                continue;
            }
            lineBuf.append((char)c);
        }
    }

    public String requestLine() {
        return this.startLine;
    }

    Headers headers() throws IOException {
        int c;
        if (this.hdrs != null) {
            return this.hdrs;
        }
        this.hdrs = new Headers();
        StrBuilder key = new StrBuilder();
        StrBuilder value = new StrBuilder();
        PushbackStream pbs = new PushbackStream(this.is);
        boolean inKey = true;
        boolean prevCR = false;
        boolean sol = true;
        while ((c = pbs.read()) != -1) {
            if (c == 13) {
                prevCR = true;
                continue;
            }
            if (c == 10 && prevCR) {
                if (key.isEmpty() && value.isEmpty()) break;
                if (sol) {
                    this.hdrs.add(key.toString(), value.toString());
                    break;
                }
                prevCR = false;
                sol = true;
                continue;
            }
            if ((c == 32 || c == 9) && sol) {
                pbs.skipWhitespace();
                inKey = false;
                sol = false;
                continue;
            }
            if (sol) {
                if (!key.isEmpty() || !value.isEmpty()) {
                    this.hdrs.add(key.toString(), value.toString());
                    key.clear();
                    value.clear();
                }
                inKey = true;
                sol = false;
            }
            if (c == 58 && inKey) {
                inKey = false;
                pbs.skipWhitespace();
                continue;
            }
            (inKey ? key : value).append(c);
        }
        return this.hdrs;
    }

    static class StrBuilder {
        private char[] buffer = new char[128];
        private int count = 0;

        StrBuilder() {
        }

        public void append(int c) {
            if (this.count == 0 && c == 32) {
                return;
            }
            if (this.count == this.buffer.length) {
                char[] tmp = new char[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, tmp, 0, this.count);
                this.buffer = tmp;
            }
            this.buffer[this.count++] = (char)c;
        }

        public String toString() {
            while (this.count > 0 && this.buffer[this.count - 1] == ' ') {
                --this.count;
            }
            return new String(this.buffer, 0, this.count);
        }

        public boolean isEmpty() {
            return this.count == 0;
        }

        public void clear() {
            this.count = 0;
        }
    }

    static class PushbackStream {
        private final InputStream is;
        private int pushback = -1;
        private boolean eof = false;

        public PushbackStream(InputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            if (this.pushback != -1) {
                try {
                    int n = this.pushback;
                    return n;
                }
                finally {
                    this.pushback = -1;
                }
            }
            if (this.eof) {
                return -1;
            }
            return this.is.read();
        }

        public void skipWhitespace() throws IOException {
            int c = this.read();
            while (c == 32 || c == 9) {
                c = this.read();
            }
            if (c == -1) {
                this.eof = true;
            } else {
                this.pushback = c;
            }
        }
    }
}

