/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import java.security.AccessController;
import java.security.PrivilegedAction;

class ServerConfig {
    private static final int DEFAULT_IDLE_TIMER_SCHEDULE_MILLIS = 10000;
    private static final long DEFAULT_IDLE_INTERVAL_IN_SECS = 30L;
    private static final int DEFAULT_MAX_CONNECTIONS = -1;
    private static final int DEFAULT_MAX_IDLE_CONNECTIONS = 200;
    private static final long DEFAULT_MAX_REQ_TIME = -1L;
    private static final long DEFAULT_MAX_RSP_TIME = -1L;
    private static final long DEFAULT_REQ_RSP_TIMER_TASK_SCHEDULE_MILLIS = 1000L;
    private static final int DEFAULT_MAX_REQ_HEADERS = 200;
    private static final long DEFAULT_DRAIN_AMOUNT = 65536L;
    private static long idleTimerScheduleMillis;
    private static long idleIntervalMillis;
    private static long drainAmount;
    private static int maxConnections;
    private static int maxIdleConnections;
    private static int maxReqHeaders;
    private static long maxReqTime;
    private static long maxRspTime;
    private static long reqRspTimerScheduleMillis;
    private static boolean debug;
    private static boolean noDelay;

    ServerConfig() {
    }

    static boolean debugEnabled() {
        return debug;
    }

    static long getIdleIntervalMillis() {
        return idleIntervalMillis;
    }

    static long getIdleTimerScheduleMillis() {
        return idleTimerScheduleMillis;
    }

    static int getMaxConnections() {
        return maxConnections;
    }

    static int getMaxIdleConnections() {
        return maxIdleConnections;
    }

    static long getDrainAmount() {
        return drainAmount;
    }

    static int getMaxReqHeaders() {
        return maxReqHeaders;
    }

    static long getMaxReqTime() {
        return maxReqTime;
    }

    static long getMaxRspTime() {
        return maxRspTime;
    }

    static long getReqRspTimerScheduleMillis() {
        return reqRspTimerScheduleMillis;
    }

    static boolean noDelay() {
        return noDelay;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            String pkg = "robaho.net.httpserver";

            @Override
            public Void run() {
                idleIntervalMillis = Long.getLong(this.pkg + ".idleInterval", 30L) * 1000L;
                if (idleIntervalMillis <= 0L) {
                    idleIntervalMillis = 30000L;
                }
                if ((idleTimerScheduleMillis = Long.getLong(this.pkg + ".clockTick", 10000L).longValue()) <= 0L) {
                    idleTimerScheduleMillis = 10000L;
                }
                maxConnections = Integer.getInteger("jdk.httpserver.maxConnections", -1);
                maxIdleConnections = Integer.getInteger(this.pkg + ".maxIdleConnections", 200);
                drainAmount = Long.getLong(this.pkg + ".drainAmount", 65536L);
                maxReqHeaders = Integer.getInteger(this.pkg + ".maxReqHeaders", 200);
                if (maxReqHeaders <= 0) {
                    maxReqHeaders = 200;
                }
                maxReqTime = Long.getLong(this.pkg + ".maxReqTime", -1L);
                maxRspTime = Long.getLong(this.pkg + ".maxRspTime", -1L);
                reqRspTimerScheduleMillis = Long.getLong(this.pkg + ".timerMillis", 1000L);
                if (reqRspTimerScheduleMillis <= 0L) {
                    reqRspTimerScheduleMillis = 1000L;
                }
                debug = Boolean.getBoolean(this.pkg + ".debug");
                noDelay = Boolean.getBoolean(this.pkg + ".nodelay");
                return null;
            }
        });
    }
}

