/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLSession;
import robaho.net.httpserver.ActivityTimer;
import robaho.net.httpserver.ChunkedInputStream;
import robaho.net.httpserver.ChunkedOutputStream;
import robaho.net.httpserver.Code;
import robaho.net.httpserver.FixedLengthInputStream;
import robaho.net.httpserver.FixedLengthOutputStream;
import robaho.net.httpserver.HttpConnection;
import robaho.net.httpserver.HttpContextImpl;
import robaho.net.httpserver.HttpExchangeImpl;
import robaho.net.httpserver.HttpsExchangeImpl;
import robaho.net.httpserver.LeftOverInputStream;
import robaho.net.httpserver.PlaceholderOutputStream;
import robaho.net.httpserver.Request;
import robaho.net.httpserver.ServerImpl;
import robaho.net.httpserver.UndefLengthOutputStream;
import robaho.net.httpserver.websockets.WebSocketHandler;

class ExchangeImpl {
    Headers reqHdrs;
    Headers rspHdrs;
    Request req;
    String method;
    URI uri;
    HttpConnection connection;
    long reqContentLen;
    long rspContentLen;
    InputStream ris;
    OutputStream ros;
    boolean close;
    boolean closed;
    boolean http10 = false;
    private static final DateTimeFormatter FORMATTER;
    private static final String HEAD = "HEAD";
    private static final String CONNECT = "CONNECT";
    InputStream uis;
    OutputStream uos;
    LeftOverInputStream uis_orig;
    PlaceholderOutputStream uos_orig;
    volatile boolean sentHeaders;
    Map<String, Object> attributes;
    int rcode = -1;
    HttpPrincipal principal;
    final boolean websocket;
    static final Charset ISO_CHARSET;
    static final String colonSpace = ": ";
    static final String CRNL = "\r\n";

    ExchangeImpl(String m, URI u, Request req, long len, HttpConnection connection) throws IOException {
        this.req = req;
        this.reqHdrs = new Headers();
        this.reqHdrs.putAll(req.headers());
        this.rspHdrs = new Headers();
        this.method = m;
        this.uri = u;
        this.connection = connection;
        this.websocket = WebSocketHandler.isWebsocketRequested(this.reqHdrs);
        if (this.websocket) {
            len = -1L;
        }
        this.reqContentLen = len;
        this.ros = req.outputStream();
        this.ris = req.inputStream();
    }

    public Headers getRequestHeaders() {
        return this.reqHdrs;
    }

    public Headers getResponseHeaders() {
        return this.rspHdrs;
    }

    public URI getRequestURI() {
        return this.uri;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public HttpContextImpl getHttpContext() {
        return this.connection.getHttpContext();
    }

    private boolean isHeadRequest() {
        return HEAD.equals(this.getRequestMethod());
    }

    private boolean isConnectRequest() {
        return CONNECT.equals(this.getRequestMethod());
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.uis_orig == null || this.uos == null) {
                this.connection.close();
                return;
            }
            if (!this.uos_orig.isWrapped()) {
                this.connection.close();
                return;
            }
            if (!this.uis_orig.isClosed()) {
                this.uis_orig.close();
            }
            this.uos.close();
        }
        catch (IOException e) {
            this.connection.close();
        }
    }

    public InputStream getRequestBody() {
        if (this.uis != null) {
            return this.uis;
        }
        if (this.websocket || this.isConnectRequest()) {
            this.uis = this.ris;
        } else if (this.reqContentLen == -1L) {
            this.uis_orig = new ChunkedInputStream(this, this.ris);
            this.uis = this.uis_orig;
        } else {
            this.uis_orig = new FixedLengthInputStream(this, this.ris, this.reqContentLen);
            this.uis = this.uis_orig;
        }
        return this.uis;
    }

    LeftOverInputStream getOriginalInputStream() {
        return this.uis_orig;
    }

    public int getResponseCode() {
        return this.rcode;
    }

    public OutputStream getResponseBody() {
        if (this.uos == null) {
            this.uos_orig = new PlaceholderOutputStream(null);
            this.uos = this.uos_orig;
        }
        return this.uos;
    }

    PlaceholderOutputStream getPlaceholderResponseBody() {
        this.getResponseBody();
        return this.uos_orig;
    }

    public void sendResponseHeaders(int rCode, long contentLen) throws IOException {
        Object values;
        System.Logger logger = this.getServerImpl().getLogger();
        if (this.sentHeaders) {
            throw new IOException("headers already sent");
        }
        this.rcode = rCode;
        String statusLine = rCode == 101 ? "HTTP/1.1 101 Switching Protocols\r\n" : "HTTP/1.1 " + rCode + Code.msg(rCode) + CRNL;
        PlaceholderOutputStream o = this.getPlaceholderResponseBody();
        this.ros.write(statusLine.getBytes(ISO_CHARSET));
        boolean noContentToSend = false;
        boolean noContentLengthHeader = false;
        this.rspHdrs.set("Date", ActivityTimer.dateAndTime());
        if (this.getAttribute("__SOCKET_WRITE_BUFFER") != null) {
            int bufferSize = (Integer)this.getAttribute("__SOCKET_WRITE_BUFFER");
            this.getConnection().getSocket().setOption(StandardSocketOptions.SO_SNDBUF, bufferSize);
        }
        if (rCode == 101) {
            logger.log(System.Logger.Level.DEBUG, () -> "switching protocols");
            if (contentLen != 0L) {
                String msg = "sendResponseHeaders: rCode = " + rCode + ": forcing contentLen = 0";
                logger.log(System.Logger.Level.WARNING, msg);
            }
            contentLen = 0L;
        } else if (rCode >= 100 && rCode < 200 || rCode == 204 || rCode == 304) {
            if (contentLen != -1L) {
                String msg = "sendResponseHeaders: rCode = " + rCode + ": forcing contentLen = -1";
                logger.log(System.Logger.Level.WARNING, msg);
            }
            contentLen = -1L;
            boolean bl = noContentLengthHeader = rCode != 304;
        }
        if (this.isHeadRequest() || rCode == 304) {
            if (contentLen >= 0L) {
                logger.log(System.Logger.Level.WARNING, "sendResponseHeaders: being invoked with a content length for a HEAD request");
            }
            noContentToSend = true;
            contentLen = 0L;
            o.setWrappedStream(new FixedLengthOutputStream(this, this.ros, contentLen));
        } else if (contentLen == 0L) {
            if (this.websocket || this.isConnectRequest()) {
                o.setWrappedStream(this.ros);
                this.close = true;
            } else if (this.http10) {
                o.setWrappedStream(new UndefLengthOutputStream(this, this.ros));
                this.close = true;
            } else {
                this.rspHdrs.set("Transfer-encoding", "chunked");
                o.setWrappedStream(new ChunkedOutputStream(this, this.ros));
            }
        } else {
            if (contentLen == -1L) {
                noContentToSend = true;
                contentLen = 0L;
            }
            if (!noContentLengthHeader) {
                this.rspHdrs.set("Content-length", Long.toString(contentLen));
            }
            o.setWrappedStream(new FixedLengthOutputStream(this, this.ros, contentLen));
        }
        if (!this.close && (values = this.rspHdrs.get("Connection")) != null) {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String val = (String)iterator.next();
                if (!val.equalsIgnoreCase("close")) continue;
                logger.log(System.Logger.Level.DEBUG, "Connection: close requested by handler");
                this.close = true;
                break;
            }
        }
        this.writeHeaders(this.rspHdrs, this.ros);
        this.rspContentLen = contentLen;
        this.sentHeaders = true;
        if (logger.isLoggable(System.Logger.Level.TRACE)) {
            logger.log(System.Logger.Level.TRACE, "Sent headers: noContentToSend=" + noContentToSend);
        }
        if (contentLen == 0L) {
            this.ros.flush();
        }
        if (noContentToSend) {
            this.close();
        }
        this.getServerImpl().logReply(rCode, this.req.requestLine(), null);
    }

    void writeHeaders(Headers map, OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder(128 * map.size());
        Set<Map.Entry<String, List<String>>> entries = map.entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            for (String val : values) {
                sb.append(Objects.requireNonNull(key));
                sb.append(colonSpace);
                sb.append(Objects.requireNonNull(val));
                sb.append(CRNL);
            }
        }
        sb.append(CRNL);
        os.write(sb.toString().getBytes(ISO_CHARSET));
    }

    public InetSocketAddress getRemoteAddress() {
        Socket s = this.connection.getSocket();
        InetAddress ia = s.getInetAddress();
        int port = s.getPort();
        return new InetSocketAddress(ia, port);
    }

    public InetSocketAddress getLocalAddress() {
        Socket s = this.connection.getSocket();
        InetAddress ia = s.getLocalAddress();
        int port = s.getLocalPort();
        return new InetSocketAddress(ia, port);
    }

    public String getProtocol() {
        StringBuilder reqline = this.req.requestLine();
        int index = reqline.lastIndexOf(" ");
        return reqline.substring(index + 1);
    }

    public SSLSession getSSLSession() {
        return this.connection.getSSLSession();
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("null name parameter");
        }
        if (this.attributes == null) {
            this.attributes = this.getHttpContext().getAttributes();
        }
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("null name parameter");
        }
        if (this.attributes == null) {
            this.attributes = this.getHttpContext().getAttributes();
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void setStreams(InputStream i, OutputStream o) {
        assert (this.uis != null);
        if (i != null) {
            this.uis = i;
        }
        if (o != null) {
            this.uos = o;
        }
    }

    HttpConnection getConnection() {
        return this.connection;
    }

    ServerImpl getServerImpl() {
        return this.getHttpContext().getServerImpl();
    }

    public HttpPrincipal getPrincipal() {
        return this.principal;
    }

    void setPrincipal(HttpPrincipal principal) {
        this.principal = principal;
    }

    static ExchangeImpl get(HttpExchange t) {
        if (t instanceof HttpExchangeImpl) {
            return ((HttpExchangeImpl)t).getExchangeImpl();
        }
        assert (t instanceof HttpsExchangeImpl);
        return ((HttpsExchangeImpl)t).getExchangeImpl();
    }

    static {
        String pattern = "EEE, dd MMM yyyy HH:mm:ss zzz";
        FORMATTER = DateTimeFormatter.ofPattern(pattern, Locale.US).withZone(ZoneId.of("GMT"));
        ISO_CHARSET = StandardCharsets.ISO_8859_1;
    }
}

