/*
 * Decompiled with CFR 0.152.
 */
package robaho.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

class Request {
    static final char CR = '\r';
    static final char LF = '\n';
    private final InputStream is;
    private final OutputStream os;
    private final StringBuilder requestLine = new StringBuilder(64);
    Headers hdrs = null;

    Request(InputStream rawInputStream, OutputStream rawout) throws IOException {
        this.is = rawInputStream;
        this.os = rawout;
        this.readRequestLine();
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    private boolean readLine(StringBuilder lineBuf) throws IOException {
        boolean gotCR = false;
        while (true) {
            int c;
            try {
                c = this.is.read();
            }
            catch (IOException e) {
                if (lineBuf.isEmpty()) {
                    return false;
                }
                throw e;
            }
            if (c == -1) {
                lineBuf.setLength(0);
                return false;
            }
            if (gotCR) {
                if (c == 10) {
                    return true;
                }
                gotCR = false;
                lineBuf.append('\r');
                lineBuf.append((char)c);
                continue;
            }
            if (c == 13) {
                gotCR = true;
                continue;
            }
            lineBuf.append((char)c);
        }
    }

    private void readRequestLine() throws IOException {
        while (this.readLine(this.requestLine)) {
            if (this.requestLine.length() <= 0) continue;
            return;
        }
    }

    private static String trimmed(BufferedBuilder bb) {
        return bb.trimmed();
    }

    public StringBuilder requestLine() {
        return this.requestLine;
    }

    Headers headers() throws IOException {
        int c;
        if (this.hdrs != null) {
            return this.hdrs;
        }
        this.hdrs = new Headers();
        BufferedBuilder key = new BufferedBuilder(32);
        BufferedBuilder value = new BufferedBuilder(128);
        PushbackStream pbs = new PushbackStream(this.is);
        BufferedBuilder current = key;
        boolean prevCR = false;
        boolean sol = true;
        while ((c = pbs.read()) != -1) {
            if (c == 13) {
                prevCR = true;
                continue;
            }
            if (c == 10 && prevCR) {
                if (key.isEmpty() && value.isEmpty()) break;
                if (sol) {
                    this.hdrs.add(Request.trimmed(key), Request.trimmed(value));
                    break;
                }
                prevCR = false;
                sol = true;
                continue;
            }
            if (sol && (c == 32 || c == 9)) {
                pbs.skipWhitespace();
                current = value;
                sol = false;
                continue;
            }
            if (sol) {
                if (!key.isEmpty() || !value.isEmpty()) {
                    this.hdrs.add(Request.trimmed(key), Request.trimmed(value));
                }
                current = key;
                sol = false;
            }
            if (c == 58 && current == key) {
                current = value;
                pbs.skipWhitespace();
                continue;
            }
            current.append((char)c);
        }
        return this.hdrs;
    }

    private static final class BufferedBuilder {
        private byte[] buffer;
        private int count;

        BufferedBuilder(int capacity) {
            this.buffer = new byte[capacity];
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        void append(char c) {
            if (this.count == this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
            }
            this.buffer[this.count++] = (byte)c;
        }

        public String trimmed() {
            int end;
            int start;
            for (start = 0; start < this.count && this.buffer[start] == 32; ++start) {
            }
            for (end = this.count; end > 0 && this.buffer[end - 1] == 32; --end) {
            }
            this.count = 0;
            return new String(this.buffer, start, end - start, StandardCharsets.ISO_8859_1);
        }
    }

    static class PushbackStream {
        private final InputStream is;
        private int pushback = -1;
        private boolean eof = false;

        public PushbackStream(InputStream is) {
            this.is = is;
        }

        public int read() throws IOException {
            if (this.pushback != -1) {
                try {
                    int n = this.pushback;
                    return n;
                }
                finally {
                    this.pushback = -1;
                }
            }
            if (this.eof) {
                return -1;
            }
            return this.is.read();
        }

        public void skipWhitespace() throws IOException {
            int c = this.read();
            while (c == 32 || c == 9) {
                c = this.read();
            }
            if (c == -1) {
                this.eof = true;
            } else {
                this.pushback = c;
            }
        }
    }
}

