/*
 * Decompiled with CFR 0.152.
 */
package org.skd.loadcode;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class CsvDataset {
    private final List<Map<String, String>> dataRows;
    private final AtomicInteger currentIndex = new AtomicInteger(0);
    private final int batchSize;
    private final boolean loop;
    private final boolean shuffle;
    private final String delimiter;

    public CsvDataset(String filePath, int batchSize, boolean loop, boolean shuffle, String delimiter) throws IOException {
        this.dataRows = this.loadCsv(filePath, delimiter);
        this.batchSize = batchSize;
        this.loop = loop;
        this.shuffle = shuffle;
        this.delimiter = delimiter;
        if (shuffle) {
            Collections.shuffle(this.dataRows);
        }
    }

    public CsvDataset(String filePath, int batchSize, boolean loop, boolean shuffle) throws IOException {
        this(filePath, batchSize, loop, shuffle, ",");
    }

    public CsvDataset(String filePath, boolean loop) throws IOException {
        this(filePath, 1, loop, false, ",");
    }

    private List<Map<String, String>> loadCsv(String filePath, String delimiter) throws IOException {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String line;
            String[] headers = br.readLine().split(delimiter);
            while ((line = br.readLine()) != null) {
                String[] values = line.split(delimiter);
                if (values.length != headers.length) continue;
                HashMap<String, String> row = new HashMap<String, String>();
                for (int i = 0; i < headers.length; ++i) {
                    row.put(headers[i].trim(), values[i].trim());
                }
                rows.add(row);
            }
        }
        return rows;
    }

    public synchronized List<Map<String, String>> getNextBatch() {
        if (this.dataRows.isEmpty()) {
            return Collections.emptyList();
        }
        int startIdx = this.currentIndex.getAndAdd(this.batchSize);
        int endIdx = Math.min(startIdx + this.batchSize, this.dataRows.size());
        if (startIdx >= this.dataRows.size()) {
            if (this.loop) {
                this.currentIndex.set(0);
                return this.getNextBatch();
            }
            return Collections.emptyList();
        }
        return this.dataRows.subList(startIdx, endIdx);
    }

    public synchronized Map<String, String> getNextRow() {
        List<Map<String, String>> batch = this.getNextBatch();
        return batch.isEmpty() ? null : batch.get(0);
    }

    public synchronized List<Map<String, String>> getNextBatch(List<String> columns) {
        return this.getNextBatch().stream().map(row -> row.entrySet().stream().filter(entry -> columns.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).collect(Collectors.toList());
    }

    public synchronized Map<String, String> getNextRow(List<String> columns) {
        List<Map<String, String>> batch = this.getNextBatch(columns);
        return batch.isEmpty() ? null : batch.get(0);
    }

    public synchronized void reset() {
        this.currentIndex.set(0);
        if (this.shuffle) {
            Collections.shuffle(this.dataRows);
        }
    }

    public synchronized void writeCsv(String filePath) throws IOException {
        if (this.dataRows.isEmpty()) {
            return;
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));){
            bw.write(String.join((CharSequence)this.delimiter, this.dataRows.get(0).keySet()));
            bw.newLine();
            for (Map<String, String> row : this.dataRows) {
                bw.write(String.join((CharSequence)this.delimiter, row.values()));
                bw.newLine();
            }
        }
    }
}

