/*
 * Decompiled with CFR 0.152.
 */
package org.skd.loadcode;

import java.lang.reflect.Method;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LoadTestExecutor {
    private int threads = 1;
    private int iterations = 1;
    private int rampUpTime = 0;
    private int testDuration = 0;
    private Method testMethod;
    private Object testInstance;
    private final AtomicInteger totalIterations = new AtomicInteger(0);
    private volatile boolean stopTest = false;
    private ThreadPoolExecutor executor;

    public LoadTestExecutor setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public LoadTestExecutor setIterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public LoadTestExecutor setRampUp(int rampUp) {
        this.rampUpTime = rampUp;
        return this;
    }

    public LoadTestExecutor setTestDuration(int duration) {
        this.testDuration = duration;
        return this;
    }

    public LoadTestExecutor addTest(Class<?> testClass, String methodName) throws Exception {
        this.testInstance = testClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.testMethod = testClass.getMethod(methodName, LoadTestExecutor.class);
        return this;
    }

    public void start() {
        System.out.println("Starting Load Test...");
        this.executor = new ThreadPoolExecutor(this.threads, this.threads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.executor.allowCoreThreadTimeOut(true);
        this.executor.setKeepAliveTime(10L, TimeUnit.SECONDS);
        long startTime = System.currentTimeMillis();
        long endTime = this.testDuration > 0 ? startTime + (long)this.testDuration * 1000L : Long.MAX_VALUE;
        for (int i = 0; i < this.threads; ++i) {
            this.addThread(i, endTime);
        }
        this.monitorAndShutdown();
    }

    private void addThread(int threadIndex, long endTime) {
        this.executor.submit(() -> {
            try {
                int rampUpDelay = this.rampUpTime > 0 ? this.rampUpTime * 1000 / this.threads : 0;
                Thread.sleep(rampUpDelay * threadIndex);
                for (int currentIteration = 0; !(this.stopTest || this.iterations != -1 && currentIteration >= this.iterations || System.currentTimeMillis() > endTime); ++currentIteration) {
                    this.totalIterations.incrementAndGet();
                    this.testMethod.invoke(this.testInstance, this);
                }
                System.out.println("Thread " + Thread.currentThread().getName() + " finished.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void addNewThreads(int numberOfThreads) {
        System.out.println("Adding " + numberOfThreads + " new threads...");
        int newThreadCount = this.threads + numberOfThreads;
        this.executor.setCorePoolSize(newThreadCount);
        this.executor.setMaximumPoolSize(newThreadCount);
        this.threads = newThreadCount;
        long endTime = this.testDuration > 0 ? System.currentTimeMillis() + (long)this.testDuration * 1000L : Long.MAX_VALUE;
        for (int i = 0; i < numberOfThreads; ++i) {
            this.addThread(i, endTime);
        }
    }

    public int getTotalThreads() {
        return this.executor.getActiveCount();
    }

    public int getTotalIterations() {
        return this.totalIterations.get();
    }

    public void shutdownService() {
        System.out.println("Shutting down LoadTestExecutor...");
        this.stopTest = true;
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    public void stop() {
        this.stopTest = true;
    }

    private void monitorAndShutdown() {
        new Thread(() -> {
            try {
                while (!this.executor.isTerminated()) {
                    if (this.iterations != -1 && this.executor.getActiveCount() == 0) {
                        System.out.println("All iterations completed. Shutting down...");
                        this.shutdownService();
                        break;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("Load test monitor interrupted.");
            }
        }).start();
    }
}

