/*
 * Decompiled with CFR 0.152.
 */
package org.skd.loadcode;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LoadTestExecutorWithExService {
    private int threads = 1;
    private int iterations = 1;
    private int rampUpTime = 0;
    private int testDuration = 0;
    private Method testMethod;
    private Object testInstance;
    private final AtomicInteger totalIterations = new AtomicInteger(0);
    private volatile boolean stopTest = false;

    public LoadTestExecutorWithExService setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public LoadTestExecutorWithExService setIterations(int iterations) {
        this.iterations = iterations;
        return this;
    }

    public LoadTestExecutorWithExService setRampUp(int rampUp) {
        this.rampUpTime = rampUp;
        return this;
    }

    public LoadTestExecutorWithExService setTestDuration(int duration) {
        this.testDuration = duration;
        return this;
    }

    public LoadTestExecutorWithExService addTest(Class<?> testClass, String methodName) throws Exception {
        this.testInstance = testClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.testMethod = testClass.getMethod(methodName, LoadTestExecutorWithExService.class);
        return this;
    }

    public void start() {
        System.out.println("Starting Load Test...");
        ExecutorService executor = Executors.newFixedThreadPool(this.threads);
        long startTime = System.currentTimeMillis();
        long endTime = this.testDuration > 0 ? startTime + (long)this.testDuration * 1000L : Long.MAX_VALUE;
        int i = 0;
        while (i < this.threads) {
            int threadIndex = i++;
            executor.submit(() -> {
                try {
                    int currentIteration;
                    int rampUpDelay = this.rampUpTime > 0 ? this.rampUpTime * 1000 / this.threads : 0;
                    Thread.sleep(rampUpDelay * threadIndex);
                    for (currentIteration = 0; !(this.stopTest || this.iterations != -1 && currentIteration >= this.iterations || System.currentTimeMillis() > endTime); ++currentIteration) {
                        this.totalIterations.incrementAndGet();
                        this.testMethod.invoke(this.testInstance, this);
                    }
                    if (this.iterations != -1 && currentIteration >= this.iterations) {
                        this.stopTest = true;
                        this.shutdownService(executor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (this.testDuration > 0) {
            try {
                executor.shutdown();
                executor.awaitTermination(this.testDuration + 5, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("Load test interrupted.");
            }
        } else {
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
                System.err.println("Load test interrupted.");
            }
        }
        System.out.println("Load Test Completed.");
    }

    public int getTotalThreads() {
        return this.threads;
    }

    public int getTotalIterations() {
        return this.totalIterations.get();
    }

    public void shutdownService(ExecutorService executor) {
        executor.shutdown();
    }

    public void stop() {
        this.stopTest = true;
    }
}

