/*
 * Decompiled with CFR 0.152.
 */
package org.skd.loadcode;

public class RPMTimer {
    private final int targetRPM;
    private final long targetIntervalMillis;
    private long lastRequestTime = System.currentTimeMillis();

    public RPMTimer(int rpm) {
        if (rpm <= 0) {
            throw new IllegalArgumentException("RPM must be greater than 0.");
        }
        this.targetRPM = rpm;
        this.targetIntervalMillis = 60000 / rpm;
    }

    public synchronized void sleep() {
        long now = System.currentTimeMillis();
        long elapsedTime = now - this.lastRequestTime;
        long sleepTime = this.targetIntervalMillis - elapsedTime;
        if (sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.lastRequestTime = System.currentTimeMillis();
    }

    public synchronized int getCurrentRPM() {
        return this.targetRPM;
    }
}

