/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.proxy;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import scouter.agent.JavaAgent;
import scouter.agent.Logger;
import scouter.agent.util.ManifestUtil;
import scouter.util.ArrayUtil;
import scouter.util.BytesClassLoader;
import scouter.util.FileUtil;
import scouter.util.HashUtil;
import scouter.util.IntKeyLinkedMap;

public class LoaderManager {
    private static ClassLoader toolsLoader;
    private static IntKeyLinkedMap<ClassLoader> loaders;

    public static synchronized ClassLoader getToolsLoader() {
        if (toolsLoader == null) {
            try {
                File tools = ManifestUtil.getToolsFile();
                toolsLoader = new URLClassLoader(new URL[]{tools.toURI().toURL()});
            }
            catch (Throwable e) {
                Logger.println("A134", e);
            }
        }
        return LoaderManager.createLoader(toolsLoader, "scouter.tools");
    }

    public static ClassLoader getHttpLoader(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "scouter.http");
    }

    public static ClassLoader getDB2Loader(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "scouter.jdbc");
    }

    public static ClassLoader getHttpClient(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "scouter.httpclient");
    }

    private static synchronized ClassLoader createLoader(ClassLoader parent, String key) {
        int hashKey = parent == null ? 0 : System.identityHashCode(parent);
        ClassLoader loader = loaders.get(hashKey ^= HashUtil.hash(key));
        if (loader == null) {
            try {
                byte[] bytes = LoaderManager.deployJarBytes(key);
                if (bytes != null) {
                    loader = new BytesClassLoader(bytes, parent);
                    loaders.put(hashKey, loader);
                }
            }
            catch (Throwable e) {
                Logger.println("A137", "SUBLOADER " + key + " " + e);
            }
        }
        return loader;
    }

    private static byte[] deployJarBytes(String jarname) {
        try {
            InputStream is = JavaAgent.class.getResourceAsStream("/" + jarname + ".jar");
            byte[] newBytes = FileUtil.readAll(is);
            is.close();
            Logger.println("NONE", "LoadJarBytes " + jarname + " " + ArrayUtil.len(newBytes) + " bytes");
            return newBytes;
        }
        catch (Exception e) {
            Logger.println("NONE", "fail to load jar bytes " + jarname);
            return null;
        }
    }

    static {
        loaders = new IntKeyLinkedMap().setMax(10);
    }
}

