/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import scouter.agent.Configure;
import scouter.agent.trace.enums.XLogDiscard;
import scouter.lang.conf.ConfObserver;
import scouter.util.KeyGen;
import scouter.util.StringUtil;
import scouter.util.matcher.CommaSeparatedChainedStrMatcher;

public class XLogSampler {
    private static XLogSampler instance = new XLogSampler();
    private Configure conf = Configure.getInstance();
    private String currentDiscardServicePatterns;
    private String currentSamplingServicePatterns;
    private CommaSeparatedChainedStrMatcher discardPatternMatcher;
    private CommaSeparatedChainedStrMatcher samplingPatternMatcher;

    private XLogSampler() {
        this.currentDiscardServicePatterns = this.conf.xlog_discard_service_patterns;
        this.currentSamplingServicePatterns = this.conf.xlog_patterned_sampling_service_patterns;
        this.discardPatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentDiscardServicePatterns);
        this.samplingPatternMatcher = new CommaSeparatedChainedStrMatcher(this.currentSamplingServicePatterns);
        ConfObserver.add("XLogSampler.StrMatch", new Runnable(){

            @Override
            public void run() {
                XLogSampler sampler = XLogSampler.getInstance();
                Configure conf = Configure.getInstance();
                if (!sampler.currentDiscardServicePatterns.equals(conf.xlog_discard_service_patterns)) {
                    sampler.currentDiscardServicePatterns = conf.xlog_discard_service_patterns;
                    sampler.discardPatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_discard_service_patterns);
                }
                if (!sampler.currentSamplingServicePatterns.equals(conf.xlog_patterned_sampling_service_patterns)) {
                    sampler.currentSamplingServicePatterns = conf.xlog_patterned_sampling_service_patterns;
                    sampler.samplingPatternMatcher = new CommaSeparatedChainedStrMatcher(conf.xlog_patterned_sampling_service_patterns);
                }
            }
        });
    }

    public static XLogSampler getInstance() {
        return instance;
    }

    public XLogDiscard evaluateXLogDiscard(int elapsed, String serviceName) {
        XLogDiscard discardMode = XLogDiscard.NONE;
        if (elapsed < this.conf.xlog_lower_bound_time_ms) {
            return XLogDiscard.DISCARD_ALL;
        }
        if (this.isDiscardServicePattern(serviceName)) {
            return XLogDiscard.DISCARD_ALL;
        }
        boolean isSamplingServicePattern = false;
        if (this.conf.xlog_patterned_sampling_enabled && (isSamplingServicePattern = this.isSamplingServicePattern(serviceName))) {
            if (elapsed < this.conf.xlog_patterned_sampling_step1_ms) {
                if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_step1_rate_pct) {
                    discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
                }
            } else if (elapsed < this.conf.xlog_patterned_sampling_step2_ms) {
                if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_step2_rate_pct) {
                    discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
                }
            } else if (elapsed < this.conf.xlog_patterned_sampling_step3_ms) {
                if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_step3_rate_pct) {
                    discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
                }
            } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_patterned_sampling_over_rate_pct) {
                XLogDiscard xLogDiscard = discardMode = this.conf.xlog_patterned_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
            }
        }
        if (!isSamplingServicePattern && this.conf.xlog_sampling_enabled) {
            if (elapsed < this.conf.xlog_sampling_step1_ms) {
                if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_step1_rate_pct) {
                    discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
                }
            } else if (elapsed < this.conf.xlog_sampling_step2_ms) {
                if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_step2_rate_pct) {
                    discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
                }
            } else if (elapsed < this.conf.xlog_sampling_step3_ms) {
                if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_step3_rate_pct) {
                    discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
                }
            } else if (Math.abs(KeyGen.next() % 100L) >= (long)this.conf.xlog_sampling_over_rate_pct) {
                discardMode = this.conf.xlog_sampling_only_profile ? XLogDiscard.DISCARD_PROFILE : XLogDiscard.DISCARD_ALL;
            }
        }
        return discardMode;
    }

    private boolean isDiscardServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_discard_service_patterns)) {
            return false;
        }
        return this.discardPatternMatcher.isMatch(serviceName);
    }

    private boolean isSamplingServicePattern(String serviceName) {
        if (StringUtil.isEmpty(this.conf.xlog_patterned_sampling_service_patterns)) {
            return false;
        }
        return this.samplingPatternMatcher.isMatch(serviceName);
    }
}

