/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class XLogPack
implements Pack {
    public long endTime;
    public int objHash;
    public int service;
    public long txid;
    public int threadNameHash;
    public long caller;
    public long gxid;
    public int elapsed;
    public int error;
    public int cpu;
    public int sqlCount;
    public int sqlTime;
    public byte[] ipaddr;
    public int kbytes;
    @Deprecated
    public int status;
    public long userid;
    public int userAgent;
    public int referer;
    public int group;
    public int apicallCount;
    public int apicallTime;
    public String countryCode;
    public int city;
    public byte xType;
    public int login;
    public int desc;
    @Deprecated
    public int webHash;
    @Deprecated
    public int webTime;
    public byte hasDump;
    public String text1;
    public String text2;
    public int queuingHostHash;
    public int queuingTime;
    public int queuing2ndHostHash;
    public int queuing2ndTime;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XLOG ");
        sb.append(DateUtil.timestamp(this.endTime));
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" service=").append(Hexa32.toString32(this.service));
        sb.append(" txid=").append(Hexa32.toString32(this.txid));
        sb.append(" caller=").append(Hexa32.toString32(this.caller));
        sb.append(" gxid=").append(Hexa32.toString32(this.gxid));
        sb.append(" elapsed=").append(this.elapsed);
        sb.append(" error=").append(this.error);
        return sb.toString();
    }

    @Override
    public byte getPackType() {
        return 21;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        DataOutputX o = new DataOutputX();
        o.writeDecimal(this.endTime);
        o.writeDecimal(this.objHash);
        o.writeDecimal(this.service);
        o.writeLong(this.txid);
        o.writeLong(this.caller);
        o.writeLong(this.gxid);
        o.writeDecimal(this.elapsed);
        o.writeDecimal(this.error);
        o.writeDecimal(this.cpu);
        o.writeDecimal(this.sqlCount);
        o.writeDecimal(this.sqlTime);
        o.writeBlob(this.ipaddr);
        o.writeDecimal(this.kbytes);
        o.writeDecimal(this.status);
        o.writeDecimal(this.userid);
        o.writeDecimal(this.userAgent);
        o.writeDecimal(this.referer);
        o.writeDecimal(this.group);
        o.writeDecimal(this.apicallCount);
        o.writeDecimal(this.apicallTime);
        o.writeText(this.countryCode);
        o.writeDecimal(this.city);
        o.writeByte(this.xType);
        o.writeDecimal(this.login);
        o.writeDecimal(this.desc);
        o.writeDecimal(this.webHash);
        o.writeDecimal(this.webTime);
        o.writeByte(this.hasDump);
        o.writeDecimal(this.threadNameHash);
        o.writeText(this.text1);
        o.writeText(this.text2);
        o.writeDecimal(this.queuingHostHash);
        o.writeDecimal(this.queuingTime);
        o.writeDecimal(this.queuing2ndHostHash);
        o.writeDecimal(this.queuing2ndTime);
        out.writeBlob(o.toByteArray());
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        DataInputX d = new DataInputX(din.readBlob());
        this.endTime = d.readDecimal();
        this.objHash = (int)d.readDecimal();
        this.service = (int)d.readDecimal();
        this.txid = d.readLong();
        this.caller = d.readLong();
        this.gxid = d.readLong();
        this.elapsed = (int)d.readDecimal();
        this.error = (int)d.readDecimal();
        this.cpu = (int)d.readDecimal();
        this.sqlCount = (int)d.readDecimal();
        this.sqlTime = (int)d.readDecimal();
        this.ipaddr = d.readBlob();
        this.kbytes = (int)d.readDecimal();
        this.status = (int)d.readDecimal();
        this.userid = d.readDecimal();
        this.userAgent = (int)d.readDecimal();
        this.referer = (int)d.readDecimal();
        this.group = (int)d.readDecimal();
        this.apicallCount = (int)d.readDecimal();
        this.apicallTime = (int)d.readDecimal();
        if (d.available() > 0) {
            this.countryCode = d.readText();
            this.city = (int)d.readDecimal();
        }
        if (d.available() > 0) {
            this.xType = d.readByte();
        }
        if (d.available() > 0) {
            this.login = (int)d.readDecimal();
            this.desc = (int)d.readDecimal();
        }
        if (d.available() > 0) {
            this.webHash = (int)d.readDecimal();
            this.webTime = (int)d.readDecimal();
        }
        if (d.available() > 0) {
            this.hasDump = d.readByte();
        }
        if (d.available() > 0) {
            this.threadNameHash = (int)d.readDecimal();
        }
        if (d.available() > 0) {
            this.text1 = d.readText();
            this.text2 = d.readText();
        }
        if (d.available() > 0) {
            this.queuingHostHash = (int)d.readDecimal();
            this.queuingTime = (int)d.readDecimal();
            this.queuing2ndHostHash = (int)d.readDecimal();
            this.queuing2ndTime = (int)d.readDecimal();
        }
        return this;
    }
}

