/*
 * Decompiled with CFR 0.152.
 */
package scouter.repack.net.bytebuddy.implementation.bytecode.constant;

import scouter.repack.net.bytebuddy.description.type.TypeDefinition;
import scouter.repack.net.bytebuddy.implementation.Implementation;
import scouter.repack.net.bytebuddy.implementation.bytecode.StackManipulation;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.LongConstant;
import scouter.repack.net.bytebuddy.implementation.bytecode.constant.NullConstant;
import scouter.repack.net.bytebuddy.jar.asm.MethodVisitor;

public enum DefaultValue implements StackManipulation
{
    INTEGER(IntegerConstant.ZERO),
    LONG(LongConstant.ZERO),
    FLOAT(FloatConstant.ZERO),
    DOUBLE(DoubleConstant.ZERO),
    VOID(StackManipulation.Trivial.INSTANCE),
    REFERENCE(NullConstant.INSTANCE);

    private final StackManipulation stackManipulation;

    private DefaultValue(StackManipulation stackManipulation) {
        this.stackManipulation = stackManipulation;
    }

    public static StackManipulation of(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            if (typeDefinition.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents(Void.TYPE)) {
                return VOID;
            }
            return INTEGER;
        }
        return REFERENCE;
    }

    @Override
    public boolean isValid() {
        return this.stackManipulation.isValid();
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return this.stackManipulation.apply(methodVisitor, implementationContext);
    }
}

