/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.ArrayList;
import java.util.Arrays;

public class SQLSimpleParser {
    SQLNode sqlNode = null;
    SQLNode currentNode = null;
    boolean inParenthesis = false;
    int parenthesisCount = 0;
    private ArrayList<Character> spliter = new ArrayList<Character>(Arrays.asList(Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('!'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\r'), Character.valueOf('\n')));
    int depth = 0;

    private void createOrAppendNode(SQLTypeEnum type) {
        ++this.depth;
        if (this.sqlNode == null) {
            this.sqlNode = new SQLNode(type, this.depth);
            this.sqlNode.nextNode = null;
        } else {
            this.appendNode(this.sqlNode, new SQLNode(type, this.depth));
        }
    }

    private void appendNode(SQLNode head, SQLNode newNode) {
        while (head.nextNode != null) {
            head = head.nextNode;
        }
        head.nextNode = newNode;
    }

    private void release() {
        this.clearNode();
        this.sqlNode = null;
        this.depth = 0;
        this.parenthesisCount = 0;
    }

    private void clearNode() {
        if (this.sqlNode == null) {
            return;
        }
        SQLNode currNode = null;
        if (this.sqlNode.nextNode != null) {
            currNode = this.sqlNode;
            this.sqlNode = this.sqlNode.nextNode;
            currNode = null;
        } else {
            this.sqlNode = null;
        }
        this.clearNode();
    }

    public String getCrudInfo(String value) {
        try {
            String[] tokens = this.tokenize(value, false);
            this.crudInfo(tokens);
        }
        catch (Exception ex) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<String> tempList = new ArrayList<String>();
        SQLNode node = this.sqlNode;
        do {
            for (int i = 0; i < node.tableList.size(); ++i) {
                StringBuffer s = new StringBuffer();
                String tblInfo = s.append(node.tableList.get(i)).append("(").append(node.type.toString()).append(")").toString();
                if (tempList.contains(tblInfo)) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(tblInfo);
                tempList.add(tblInfo);
            }
        } while ((node = node.nextNode) != null);
        this.release();
        return sb.toString();
    }

    public void printCRUD() {
        do {
            System.out.print("type:" + this.sqlNode.type.toString() + "-->");
            for (int i = 0; i < this.sqlNode.tableList.size(); ++i) {
                System.out.print(this.sqlNode.tableList.get(i) + " ");
            }
            System.out.println();
            this.sqlNode = this.sqlNode.nextNode;
        } while (this.sqlNode != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void crudInfo(String[] tokens) throws Exception {
        block2: for (int i = 0; i < tokens.length; ++i) {
            block17: {
                String token = tokens[i].toUpperCase();
                if (token.equals("(")) {
                    ++this.parenthesisCount;
                    this.inParenthesis = true;
                    continue;
                }
                if (token.equals(")")) {
                    --this.parenthesisCount;
                    if (this.parenthesisCount != 0) continue;
                    this.inParenthesis = false;
                    continue;
                }
                if (token.equals("SELECT")) {
                    if (this.inParenthesis) {
                        break block17;
                    } else {
                        this.createOrAppendNode(SQLTypeEnum.SELECT);
                        continue;
                    }
                }
                if (token.equals("DELETE")) {
                    this.createOrAppendNode(SQLTypeEnum.DELETE);
                    continue;
                }
                if (token.equals("INSERT")) {
                    this.createOrAppendNode(SQLTypeEnum.INSERT);
                    continue;
                }
                if (token.equals("UPDATE")) {
                    this.createOrAppendNode(SQLTypeEnum.UPDATE);
                    i = this.applyNode(i, tokens);
                    continue;
                }
                if (token.equals("MERGE")) {
                    if (!tokens[i + 1].toUpperCase().equals("INTO")) continue;
                    this.createOrAppendNode(SQLTypeEnum.MERGE);
                    continue;
                }
                if (token.equals("FROM")) {
                    i = this.applyNode(i, tokens);
                    continue;
                }
                if (token.equals("INTO")) {
                    i = this.applyNode(i, tokens);
                    continue;
                }
                if (!token.equals("JOIN")) continue;
                this.createOrAppendNode(SQLTypeEnum.SELECT);
                i = this.applyNode(i, tokens);
                continue;
            }
            for (int j = i + 1; j < tokens.length; ++j) {
                if (tokens[j].toLowerCase().equals("from")) {
                    this.createOrAppendNode(SQLTypeEnum.SELECT);
                    j = this.applyNode(j, tokens);
                }
                if (tokens[j].equals("(")) {
                    ++this.parenthesisCount;
                    this.inParenthesis = true;
                }
                if (!tokens[j].equals(")")) continue;
                --this.parenthesisCount;
                if (this.parenthesisCount != 0) continue;
                this.inParenthesis = false;
                i = j;
                continue block2;
            }
        }
        return;
    }

    private int applyNode(int index, String[] tokens) throws Exception {
        int returnIndex = index;
        if (index == tokens.length - 1) {
            throw new RuntimeException(index + " is the last index of tokens.");
        }
        if (this.depth == 0) {
            return index;
        }
        SQLNode node = this.findNode(this.depth);
        if (node == null) {
            throw new RuntimeException("Can't find node which has proper depth.");
        }
        if (node.type == SQLTypeEnum.SELECT) {
            if (!tokens[index + 1].equals("(")) {
                node.tableList.add(tokens[index + 1]);
                returnIndex = index + 1;
                int step = 0;
                if (tokens.length > index + 2 && tokens[index + 2].equals(",")) {
                    step = 2;
                }
                if (tokens.length > index + 3 && tokens[index + 3].equals(",")) {
                    step = 3;
                }
                if (step > 0) {
                    for (int i = index + 1; i < tokens.length && tokens.length >= i + step && tokens[i + step - 1].equals(","); i += step) {
                        if (tokens[i + step].equals("(")) continue;
                        node.tableList.add(tokens[i + step]);
                        returnIndex = i + step;
                    }
                }
            }
        } else {
            node.tableList.add(tokens[index + 1]);
            returnIndex = index + 1;
        }
        node.depth = -1;
        --this.depth;
        return returnIndex;
    }

    private SQLNode findNode(int depth) {
        SQLNode node = this.sqlNode;
        if (node.nextNode == null) {
            return node;
        }
        while (node.nextNode != null) {
            node = node.nextNode;
            if (node.depth != depth) continue;
            break;
        }
        return node;
    }

    private String[] tokenize(String value, boolean keepComments) throws Exception {
        char[] arrays = value.toCharArray();
        boolean hasQuotation = false;
        boolean hasSingleLineComments = false;
        boolean hasMultiLineComments = false;
        int start = 0;
        ArrayList<String> tokenList = new ArrayList<String>();
        int len = arrays.length;
        for (int i = 0; i < len; ++i) {
            char[] token;
            if (i == len - 1) {
                if (this.spliter.contains(Character.valueOf(arrays[i]))) {
                    token = Arrays.copyOfRange(arrays, start, len - 1);
                    tokenList.add(new String(token));
                    if (arrays[i] == ' ') break;
                    tokenList.add(String.valueOf(arrays[i]));
                    break;
                }
                token = Arrays.copyOfRange(arrays, start, len);
                tokenList.add(new String(token));
                break;
            }
            if (arrays[i] == '\'') {
                if (!hasQuotation) {
                    hasQuotation = true;
                    continue;
                }
                hasQuotation = false;
                continue;
            }
            if (arrays[i] == '-') {
                if (hasQuotation || i >= len - 1 || arrays[i + 1] != '-') continue;
                hasSingleLineComments = true;
                continue;
            }
            if (arrays[i] == '#') {
                if (hasQuotation) continue;
                hasSingleLineComments = true;
                continue;
            }
            if (arrays[i] == '\n' && hasSingleLineComments) {
                hasSingleLineComments = false;
            }
            if (arrays[i] == '/') {
                if (i < len - 1 && arrays[i + 1] == '*') {
                    hasMultiLineComments = true;
                }
                if (i <= 0 || arrays[i - 1] != '*' || !hasMultiLineComments) continue;
                hasMultiLineComments = false;
                if (keepComments) continue;
                start = i + 1;
                continue;
            }
            if (i <= 0 || !this.spliter.contains(Character.valueOf(arrays[i])) || hasQuotation || hasSingleLineComments || hasMultiLineComments) continue;
            if (i >= start) {
                token = Arrays.copyOfRange(arrays, start, i);
                if (token.length > 0) {
                    tokenList.add(new String(token));
                }
                if (arrays[i] == ' ') {
                    start = i + 1;
                    continue;
                }
                if (arrays[i] == '\r') {
                    if (arrays[i + 1] == '\n') {
                        start = i + 2;
                        ++i;
                        continue;
                    }
                    start = i + 1;
                    continue;
                }
                if (arrays[i] == '\n') {
                    start = i + 1;
                    continue;
                }
                if (this.spliter.contains(Character.valueOf(arrays[i + 1]))) {
                    String temp = "" + arrays[i] + arrays[i + 1];
                    if (temp.equals("<>") || temp.equals("!=") || temp.equals("<=") || temp.equals(">=")) {
                        tokenList.add(temp);
                        start = i + 1;
                        ++i;
                    } else {
                        tokenList.add(String.valueOf(arrays[i]));
                    }
                } else {
                    tokenList.add(String.valueOf(arrays[i]));
                }
            }
            start = i + 1;
        }
        return tokenList.toArray(new String[tokenList.size()]);
    }

    static enum SQLTypeEnum {
        SELECT,
        DELETE,
        UPDATE,
        INSERT,
        MERGE;


        public String toString() {
            switch (this) {
                case SELECT: {
                    return "R";
                }
                case DELETE: {
                    return "D";
                }
                case UPDATE: {
                    return "U";
                }
                case INSERT: {
                    return "C";
                }
                case MERGE: {
                    return "C";
                }
            }
            return "R";
        }
    }

    public class SQLNode {
        SQLTypeEnum type;
        ArrayList<String> tableList;
        int depth;
        SQLNode nextNode = null;

        public SQLNode() {
            this.tableList = new ArrayList();
            this.depth = 0;
        }

        public SQLNode(SQLTypeEnum type) {
            this.tableList = new ArrayList();
            this.type = type;
        }

        public SQLNode(SQLTypeEnum type, int depth) {
            this.type = type;
            this.tableList = new ArrayList();
            this.depth = depth;
        }
    }
}

