/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.Logger;
import scouter.agent.asm.JDBCDriverMV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;

class JDBCDriverCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;

    public JDBCDriverCV(ClassVisitor cv, HookingSet mset, String className) {
        super(327680, cv);
        this.mset = mset;
        this.className = className;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(name, desc)) {
            return mv;
        }
        if (AsmUtil.isSpecial(name)) {
            return mv;
        }
        String fullname = AsmUtil.makeMethodFullName(this.className, name, desc);
        Logger.println("A105", "jdbc db2 driver  loaded: " + fullname);
        return new JDBCDriverMV(access, desc, mv, fullname);
    }
}

