/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.plugin;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import scouter.agent.Logger;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.plugin.WrContext;
import scouter.agent.plugin.Wrapper;
import scouter.agent.trace.AlertProxy;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.TransferMap;
import scouter.lang.step.ApiCallStep;
import scouter.lang.step.ThreadSubmitStep;
import scouter.util.KeyGen;
import scouter.util.SysJMX;

public class AbstractPlugin {
    private static Map<String, AccessibleObject> reflCache = Collections.synchronizedMap(new LinkedHashMap(100));
    long lastModified;

    public void log(Object c) {
        Logger.println("A158", c.toString());
    }

    public void println(Object c) {
        System.out.println(c);
    }

    public static Object invokeMethod(Object o, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] objs = new Object[]{};
        return AbstractPlugin.invokeMethod(o, methodName, objs);
    }

    public static Object invokeMethod(Object o, String methodName, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        int argsSize = args.length;
        StringBuilder signature = new StringBuilder(o.getClass().getName()).append(":").append(methodName).append("():");
        Class[] argClazzes = new Class[argsSize];
        for (int i = 0; i < argsSize; ++i) {
            argClazzes[i] = args[i].getClass();
        }
        return AbstractPlugin.invokeMethod(o, methodName, argClazzes, args);
    }

    public static Object invokeMethod(Object o, String methodName, Class[] argTypes, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        int argsSize = args.length;
        StringBuilder signature = new StringBuilder(o.getClass().getName()).append(":").append(methodName).append("():");
        for (int i = 0; i < argsSize; ++i) {
            signature.append(argTypes[i].getName()).append("+");
        }
        Method m = (Method)reflCache.get(signature.toString());
        if (m == null) {
            m = o.getClass().getMethod(methodName, argTypes);
            reflCache.put(signature.toString(), m);
        }
        return m.invoke(o, args);
    }

    public static Object newInstance(String className) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return AbstractPlugin.newInstance(className, Thread.currentThread().getContextClassLoader());
    }

    public static Object newInstance(String className, ClassLoader loader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objs = new Object[]{};
        return AbstractPlugin.newInstance(className, loader, objs);
    }

    public static Object newInstance(String className, Object[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return AbstractPlugin.newInstance(className, Thread.currentThread().getContextClassLoader(), args);
    }

    public static Object newInstance(String className, ClassLoader loader, Object[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int argsSize = args.length;
        Class[] argClazzes = new Class[argsSize];
        for (int i = 0; i < argsSize; ++i) {
            argClazzes[i] = args[i].getClass();
        }
        return AbstractPlugin.newInstance(className, loader, argClazzes, args);
    }

    public static Object newInstance(String className, ClassLoader loader, Class[] argTypes, Object[] args) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int argsSize = args.length;
        StringBuilder signature = new StringBuilder(className).append(":<init>:");
        for (int i = 0; i < argsSize; ++i) {
            signature.append(argTypes[i].getName()).append("+");
        }
        Class<?> clazz = Class.forName(className, true, loader);
        Constructor<?> constructor = (Constructor<?>)reflCache.get(signature.toString());
        if (constructor == null) {
            constructor = clazz.getConstructor(argTypes);
            reflCache.put(signature.toString(), constructor);
        }
        return constructor.newInstance(args);
    }

    public static Object getFieldValue(Object o, String fieldName) throws InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        StringBuilder signature = new StringBuilder(o.getClass().getName()).append(":").append(fieldName).append(":");
        Field f = (Field)reflCache.get(signature.toString());
        if (f == null) {
            f = o.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            reflCache.put(signature.toString(), f);
        }
        return f.get(o);
    }

    @Deprecated
    public Object field(Object o, String field) {
        if (o == null) {
            return null;
        }
        try {
            Field f = o.getClass().getDeclaredField(field);
            f.setAccessible(true);
            return f.get(o);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Deprecated
    public Object method(Object o, String method) {
        if (o == null) {
            return null;
        }
        try {
            Method m = o.getClass().getMethod(method, Wrapper.arg_c);
            m.setAccessible(true);
            return m.invoke(o, Wrapper.arg_o);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Deprecated
    public Object method1(Object o, String method) {
        if (o == null) {
            return null;
        }
        try {
            Method m = o.getClass().getMethod(method, Wrapper.arg_c);
            return m.invoke(o, Wrapper.arg_o);
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    @Deprecated
    public Object method(Object o, String method, String param) {
        if (o == null) {
            return null;
        }
        try {
            Method m = o.getClass().getMethod(method, Wrapper.arg_c_s);
            return m.invoke(o, param);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public String toString(Object o, String def) {
        return o == null ? def : o.toString();
    }

    public void alert(char level, String title, String message) {
        switch (level) {
            case 'I': 
            case 'i': {
                AlertProxy.sendAlert((byte)0, title, message);
            }
            case 'W': 
            case 'w': {
                AlertProxy.sendAlert((byte)1, title, message);
                break;
            }
            case 'E': 
            case 'e': {
                AlertProxy.sendAlert((byte)2, title, message);
                break;
            }
            case 'F': 
            case 'f': {
                AlertProxy.sendAlert((byte)3, title, message);
            }
        }
    }

    public int syshash(Object o) {
        if (o == null) {
            return 0;
        }
        return System.identityHashCode(o);
    }

    public int syshash(HookArgs hook, int x) {
        if (x >= hook.args.length) {
            return 0;
        }
        return this.syshash(hook.args[x]);
    }

    public int syshash(HookArgs hook) {
        if (hook == null || hook.this1 == null) {
            return 0;
        }
        return this.syshash(hook.this1);
    }

    public void forward(WrContext wctx, int uuid) {
        TraceContext ctx = wctx.inner();
        if (ctx.gxid == 0L) {
            ctx.gxid = ctx.txid;
        }
        long callee = KeyGen.next();
        TransferMap.put(uuid, ctx.gxid, ctx.txid, callee, (byte)1);
        ApiCallStep step = new ApiCallStep();
        step.txid = callee;
        step.start_time = (int)(System.currentTimeMillis() - ctx.startTime);
        if (ctx.profile_thread_cputime) {
            step.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - ctx.startCpu);
        }
        step.hash = DataProxy.sendApicall("local-forward");
        ctx.profile.add(step);
    }

    public void forwardThread(WrContext wctx, int uuid) {
        if (wctx == null) {
            return;
        }
        TraceContext ctx = wctx.inner();
        if (ctx.gxid == 0L) {
            ctx.gxid = ctx.txid;
        }
        long callee = KeyGen.next();
        TransferMap.put(uuid, ctx.gxid, ctx.txid, callee, (byte)2);
        ThreadSubmitStep step = new ThreadSubmitStep();
        step.txid = callee;
        step.start_time = (int)(System.currentTimeMillis() - ctx.startTime);
        if (ctx.profile_thread_cputime) {
            step.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - ctx.startCpu);
        }
        step.hash = DataProxy.sendApicall("local-forward");
        ctx.profile.add(step);
    }

    public void receive(WrContext ctx, int uuid) {
        TransferMap.ID id = TransferMap.get(uuid);
        if (id == null) {
            return;
        }
        TransferMap.remove(uuid);
        if (id.gxid != 0L) {
            ctx.inner().gxid = id.gxid;
        }
        if (id.callee != 0L) {
            ctx.inner().txid = id.callee;
        }
        if (id.caller != 0L) {
            ctx.inner().caller = id.caller;
        }
        ctx.inner().xType = id.xType;
    }

    public static Class[] makeArgTypes(Class class0) {
        Class[] classes = new Class[]{class0};
        return classes;
    }

    public static Class[] makeArgTypes(Class class0, Class class1) {
        Class[] classes = new Class[]{class0, class1};
        return classes;
    }

    public static Class[] makeArgTypes(Class class0, Class class1, Class class2) {
        Class[] classes = new Class[]{class0, class1, class2};
        return classes;
    }

    public static Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3) {
        Class[] classes = new Class[]{class0, class1, class2, class3};
        return classes;
    }

    public static Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4};
        return classes;
    }

    public static Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4, Class class5) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4, class5};
        return classes;
    }

    public static Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4, Class class5, Class class6) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4, class5, class6};
        return classes;
    }

    public static Class[] makeArgTypes(Class class0, Class class1, Class class2, Class class3, Class class4, Class class5, Class class6, Class class7) {
        Class[] classes = new Class[]{class0, class1, class2, class3, class4, class5, class6, class7};
        return classes;
    }

    public static Object[] makeArgs(Object object0) {
        Object[] objects = new Object[]{object0};
        return objects;
    }

    public static Object[] makeArgs(Object object0, Object object1) {
        Object[] objects = new Object[]{object0, object1};
        return objects;
    }

    public static Object[] makeArgs(Object object0, Object object1, Object object2) {
        Object[] objects = new Object[]{object0, object1, object2};
        return objects;
    }

    public static Object[] makeArgs(Object object0, Object object1, Object object2, Object object3) {
        Object[] objects = new Object[]{object0, object1, object2, object3};
        return objects;
    }

    public static Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4};
        return objects;
    }

    public static Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4, Object object5) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4, object5};
        return objects;
    }

    public static Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4, object5, object6};
        return objects;
    }

    public static Object[] makeArgs(Object object0, Object object1, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objects = new Object[]{object0, object1, object2, object3, object4, object5, object6, object7};
        return objects;
    }
}

