/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import java.sql.SQLException;
import java.util.Map;
import scouter.agent.Configure;
import scouter.agent.error.TOO_MANY_COLLECTION_MEMBERS;
import scouter.agent.netio.data.DataProxy;
import scouter.agent.summary.ServiceSummary;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.TraceContextManager;
import scouter.lang.pack.AlertPack;
import scouter.lang.step.HashedMessageStep;
import scouter.lang.value.MapValue;
import scouter.util.ThreadUtil;

public class TraceCollection {
    private static Configure conf = Configure.getInstance();
    private static SQLException tooManyCollectionMemebers = new TOO_MANY_COLLECTION_MEMBERS("TOO_MANY_COLLECTION_MEMBERS", "TOO_MANY_COLLECTION_MEMBERS");

    public static void endPut(Map map) {
        int size = map.size();
        if (size > 0 && size % TraceCollection.conf._hook_map_impl_warning_size == 0) {
            TraceContext ctx = TraceContextManager.getContext();
            if (ctx == null) {
                return;
            }
            if (ctx.error != 0) {
                return;
            }
            MapValue mv = new MapValue();
            mv.put(AlertPack.HASH_FLAG + "service" + "_service-name", ctx.serviceHash);
            String message = "Too many Map entries!\n" + ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2);
            HashedMessageStep step = new HashedMessageStep();
            step.hash = DataProxy.sendHashedMessage(message);
            step.value = size;
            step.start_time = (int)(System.currentTimeMillis() - ctx.startTime);
            ctx.profile.add(step);
            mv.put(AlertPack.HASH_FLAG + "hmsg" + "_full-stack", step.hash);
            DataProxy.sendAlert((byte)1, "TOO_MANY_MAP_ENTRIES", "too many Map entries, over #" + size, mv);
            int errorMessageHash = DataProxy.sendError("too many Map entries, over #" + size);
            if (ctx.error == 0) {
                ctx.error = errorMessageHash;
            }
            ServiceSummary.getInstance().process(tooManyCollectionMemebers, errorMessageHash, ctx.serviceHash, ctx.txid, 0, 0);
        }
    }
}

