/*
 * Decompiled with CFR 0.152.
 */
package scouter.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import scouter.agent.trace.SqlParameter;
import scouter.agent.trace.TraceSQL;
import scouter.jdbc.WrResultSet;
import scouter.jdbc.WrStatement;

public class WrPreparedStatement
extends WrStatement
implements PreparedStatement {
    PreparedStatement inner;
    SqlParameter sql = new SqlParameter();

    public WrPreparedStatement(PreparedStatement inner, String sql) {
        super(inner);
        this.inner = inner;
        this.sql.setSql(sql);
    }

    @Override
    public final void setBoolean(int a0, boolean a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setBoolean(a0, a1);
    }

    @Override
    public final void setByte(int a0, byte a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setByte(a0, a1);
    }

    @Override
    public final void setShort(int a0, short a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setShort(a0, a1);
    }

    @Override
    public final void setInt(int a0, int a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setInt(a0, a1);
    }

    @Override
    public final void setLong(int a0, long a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setLong(a0, a1);
    }

    @Override
    public final void setFloat(int a0, float a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setFloat(a0, a1);
    }

    @Override
    public final void setDouble(int a0, double a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setDouble(a0, a1);
    }

    @Override
    public final void setTimestamp(int a0, Timestamp a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setTimestamp(a0, a1);
    }

    @Override
    public final void setTimestamp(int a0, Timestamp a1, Calendar a2) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setTimestamp(a0, a1, a2);
    }

    @Override
    public final void setURL(int a0, URL a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setURL(a0, a1);
    }

    @Override
    public final void setTime(int a0, Time a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setTime(a0, a1);
    }

    @Override
    public final void setTime(int a0, Time a1, Calendar a2) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setTime(a0, a1, a2);
    }

    @Override
    public final boolean execute() throws SQLException {
        Object stat = TraceSQL.start((Object)this, this.sql, (byte)16);
        try {
            boolean b = this.inner.execute();
            TraceSQL.end(stat, null, TraceSQL.toInt(b));
            return b;
        }
        catch (SQLException ex) {
            TraceSQL.end(stat, ex, -3);
            throw ex;
        }
        catch (Throwable t) {
            TraceSQL.end(stat, t, -3);
            throw new SQLException(t);
        }
    }

    @Override
    public final ResultSet executeQuery() throws SQLException {
        Object stat = TraceSQL.start((Object)this, this.sql, (byte)48);
        try {
            ResultSet rs = this.inner.executeQuery();
            TraceSQL.end(stat, null, -1);
            return new WrResultSet(rs);
        }
        catch (SQLException ex) {
            TraceSQL.end(stat, ex, -3);
            throw ex;
        }
        catch (Throwable t) {
            TraceSQL.end(stat, t, -3);
            throw new SQLException(t);
        }
    }

    @Override
    public final int executeUpdate() throws SQLException {
        Object stat = TraceSQL.start((Object)this, this.sql, (byte)32);
        try {
            int n = this.inner.executeUpdate();
            TraceSQL.end(stat, null, n);
            return n;
        }
        catch (SQLException ex) {
            TraceSQL.end(stat, ex, -3);
            throw ex;
        }
        catch (Throwable t) {
            TraceSQL.end(stat, t, -3);
            throw new SQLException(t);
        }
    }

    @Override
    public final void setNull(int a0, int a1, String a2) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setNull(a0, a1, a2);
    }

    @Override
    public final void setNull(int a0, int a1) throws SQLException {
        TraceSQL.set(this.sql, a0, null);
        this.inner.setNull(a0, a1);
    }

    @Override
    public final void setBigDecimal(int a0, BigDecimal a1) throws SQLException {
        this.inner.setBigDecimal(a0, a1);
    }

    @Override
    public final void setString(int a0, String a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setString(a0, a1);
    }

    @Override
    public final void setBytes(int a0, byte[] a1) throws SQLException {
        TraceSQL.set(this.sql, a0, "[bytes]");
        this.inner.setBytes(a0, a1);
    }

    @Override
    public final void setDate(int a0, Date a1, Calendar a2) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setDate(a0, a1, a2);
    }

    @Override
    public final void setDate(int a0, Date a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setDate(a0, a1);
    }

    @Override
    public final void setAsciiStream(int a0, InputStream a1, int a2) throws SQLException {
        TraceSQL.set(this.sql, a0, "[asiistream]");
        this.inner.setAsciiStream(a0, a1, a2);
    }

    @Override
    public final void setAsciiStream(int a0, InputStream a1) throws SQLException {
        TraceSQL.set(this.sql, a0, "[asciistream]");
        this.inner.setAsciiStream(a0, a1);
    }

    @Override
    public final void setAsciiStream(int a0, InputStream a1, long a2) throws SQLException {
        TraceSQL.set(this.sql, a0, "[asciistream]");
        this.inner.setAsciiStream(a0, a1, a2);
    }

    @Override
    public final void setUnicodeStream(int a0, InputStream a1, int a2) throws SQLException {
        this.inner.setUnicodeStream(a0, a1, a2);
    }

    @Override
    public final void setBinaryStream(int a0, InputStream a1, int a2) throws SQLException {
        TraceSQL.set(this.sql, a0, "[binstream]");
        this.inner.setBinaryStream(a0, a1, a2);
    }

    @Override
    public final void setBinaryStream(int a0, InputStream a1, long a2) throws SQLException {
        TraceSQL.set(this.sql, a0, "[binstream]");
        this.inner.setBinaryStream(a0, a1, a2);
    }

    @Override
    public final void setBinaryStream(int a0, InputStream a1) throws SQLException {
        TraceSQL.set(this.sql, a0, "[binstream]");
        this.inner.setBinaryStream(a0, a1);
    }

    @Override
    public final void clearParameters() throws SQLException {
        this.sql.clear();
        this.inner.clearParameters();
    }

    @Override
    public final void setObject(int a0, Object a1, int a2, int a3) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setObject(a0, a1, a2, a3);
    }

    @Override
    public final void setObject(int a0, Object a1, int a2) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setObject(a0, a1, a2);
    }

    @Override
    public final void setObject(int a0, Object a1) throws SQLException {
        TraceSQL.set(this.sql, a0, a1);
        this.inner.setObject(a0, a1);
    }

    @Override
    public final void addBatch() throws SQLException {
        this.inner.addBatch();
    }

    @Override
    public final void setCharacterStream(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setCharacterStream(a0, a1, a2);
    }

    @Override
    public final void setCharacterStream(int a0, Reader a1, int a2) throws SQLException {
        this.inner.setCharacterStream(a0, a1, a2);
    }

    @Override
    public final void setCharacterStream(int a0, Reader a1) throws SQLException {
        this.inner.setCharacterStream(a0, a1);
    }

    @Override
    public final void setRef(int a0, Ref a1) throws SQLException {
        this.inner.setRef(a0, a1);
    }

    @Override
    public final void setBlob(int a0, InputStream a1, long a2) throws SQLException {
        TraceSQL.set(this.sql, a0, "[blob]");
        this.inner.setBlob(a0, a1, a2);
    }

    @Override
    public final void setBlob(int a0, InputStream a1) throws SQLException {
        TraceSQL.set(this.sql, a0, "[blob]");
        this.inner.setBlob(a0, a1);
    }

    @Override
    public final void setBlob(int a0, Blob a1) throws SQLException {
        TraceSQL.set(this.sql, a0, "[blob]");
        this.inner.setBlob(a0, a1);
    }

    @Override
    public final void setClob(int a0, Reader a1) throws SQLException {
        this.inner.setClob(a0, a1);
    }

    @Override
    public final void setClob(int a0, Clob a1) throws SQLException {
        TraceSQL.set(this.sql, a0, "[clob]");
        this.inner.setClob(a0, a1);
    }

    @Override
    public final void setClob(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setClob(a0, a1, a2);
    }

    @Override
    public final void setArray(int a0, Array a1) throws SQLException {
        TraceSQL.set(this.sql, a0, "[array]");
        this.inner.setArray(a0, a1);
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.inner.getMetaData();
    }

    @Override
    public final ParameterMetaData getParameterMetaData() throws SQLException {
        return this.inner.getParameterMetaData();
    }

    @Override
    public final void setRowId(int a0, RowId a1) throws SQLException {
        this.inner.setRowId(a0, a1);
    }

    @Override
    public final void setNString(int a0, String a1) throws SQLException {
        this.inner.setNString(a0, a1);
    }

    @Override
    public final void setNCharacterStream(int a0, Reader a1) throws SQLException {
        this.inner.setNCharacterStream(a0, a1);
    }

    @Override
    public final void setNCharacterStream(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setNCharacterStream(a0, a1, a2);
    }

    @Override
    public final void setNClob(int a0, Reader a1) throws SQLException {
        this.inner.setNClob(a0, a1);
    }

    @Override
    public final void setNClob(int a0, Reader a1, long a2) throws SQLException {
        this.inner.setNClob(a0, a1, a2);
    }

    @Override
    public final void setNClob(int a0, NClob a1) throws SQLException {
        this.inner.setNClob(a0, a1);
    }

    @Override
    public final void setSQLXML(int a0, SQLXML a1) throws SQLException {
        this.inner.setSQLXML(a0, a1);
    }
}

