/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;

public class MapPack
implements Pack {
    protected Map<String, Value> table = new LinkedHashMap<String, Value>();

    public int size() {
        return this.table.size();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.table.containsKey(key);
    }

    public Iterator<String> keys() {
        return this.table.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.table.keySet();
    }

    public Value get(String key) {
        return this.table.get(key);
    }

    public boolean getBoolean(String key) {
        Value v = this.get(key);
        if (v instanceof BooleanValue) {
            return ((BooleanValue)v).value;
        }
        return false;
    }

    public int getInt(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).intValue();
        }
        return 0;
    }

    public long getLong(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).longValue();
        }
        return 0L;
    }

    public float getFloat(String key) {
        Value v = this.get(key);
        if (v instanceof Number) {
            return ((Number)((Object)v)).floatValue();
        }
        return 0.0f;
    }

    public String getText(String key) {
        Value v = this.get(key);
        if (v instanceof TextValue) {
            return ((TextValue)v).value;
        }
        return null;
    }

    public Value put(String key, Value value) {
        return this.table.put(key, value);
    }

    public Value put(String key, String value) {
        return this.put(key, new TextValue(value));
    }

    public Value put(String key, long value) {
        return this.put(key, new DecimalValue(value));
    }

    public Value put(String key, boolean value) {
        return this.put(key, new BooleanValue(value));
    }

    public Value remove(String key) {
        return this.table.remove(key);
    }

    public void clear() {
        this.table.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("MapPack ");
        buf.append(this.table);
        return buf.toString();
    }

    @Override
    public byte getPackType() {
        return 10;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeDecimal(this.table.size());
        for (Map.Entry<String, Value> e : this.table.entrySet()) {
            dout.writeText(e.getKey());
            dout.writeValue(e.getValue());
        }
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        int count = (int)din.readDecimal();
        for (int t = 0; t < count; ++t) {
            String key = din.readText();
            Value value = din.readValue();
            this.put(key, value);
        }
        return this;
    }

    public ListValue newList(String name) {
        ListValue list = new ListValue();
        this.put(name, list);
        return list;
    }

    public ListValue getList(String key) {
        return (ListValue)this.table.get(key);
    }

    public ListValue getListNotNull(String key) {
        ListValue lv = (ListValue)this.table.get(key);
        return lv == null ? new ListValue() : lv;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapPack other = (MapPack)obj;
        if (this.size() != other.size()) {
            return false;
        }
        Set<String> keySet = this.keySet();
        for (String key : keySet) {
            Value v1 = this.get(key);
            Value v2 = other.get(key);
            if (v2 == null) {
                return false;
            }
            if (v1.toJavaObject().equals(v2.toJavaObject())) continue;
            return false;
        }
        return true;
    }

    public MapValue toMapValue() {
        MapValue map = new MapValue();
        map.putAll(this.table);
        return map;
    }

    public MapPack setMapValue(MapValue mapValue) {
        if (mapValue == null) {
            return this;
        }
        Enumeration<String> keys = mapValue.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Value value = mapValue.get(key);
            this.table.put(key, value);
        }
        return this;
    }
}

