/*
 * Decompiled with CFR 0.152.
 */
package scouter.test;

import java.util.Random;
import java.util.Stack;
import scouter.AnyTrace;
import scouter.agent.AgentBoot;
import scouter.agent.Configure;
import scouter.agent.netio.data.net.TcpRequestMgr;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.TraceContextManager;
import scouter.agent.trace.TraceMain;
import scouter.io.DataOutputX;
import scouter.lang.pack.XLogPack;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.HashUtil;
import scouter.util.IPUtil;
import scouter.util.KeyGen;
import scouter.util.ShellArg;
import scouter.util.SysJMX;
import scouter.util.ThreadUtil;

public class Service24H {
    static int[] rate = new int[]{2, 2, 3, 3, 4, 5, 6, 7, 8, 9, 10, 10, 9, 10, 8, 7, 6, 5, 4, 3, 3, 2, 1, 1};
    static Stack<Integer> stack = new Stack();
    static Random r = new Random();
    static long time = DateUtil.yyyymmdd(DateUtil.yyyymmdd());

    public static void main(String[] args) {
        long x;
        ShellArg sh = new ShellArg(args);
        String server = sh.get("-h", "127.0.0.1");
        String port = sh.get("-p", "6100");
        int tps = CastUtil.cint(sh.get("-tps", "5000"));
        String type = sh.get("-type", "tomcat");
        String name = sh.get("-name", "java" + SysJMX.getProcessPID());
        System.setProperty("obj_type", type);
        System.setProperty("obj_name", name);
        System.setProperty("server.addr", server);
        System.setProperty("server.port", port);
        System.out.println("Scouter Test Simulation!!");
        System.out.println("  server = " + server + ":" + port);
        System.out.println("  tcp = " + tps);
        AgentBoot.boot();
        TcpRequestMgr.getInstance();
        double interval = 1000.0 / (double)tps;
        long now = System.currentTimeMillis();
        Random r = new Random();
        long txcount = 0L;
        double tm = 0.0;
        long last_unit = 0L;
        do {
            ++txcount;
            String serviceName = "service" + Service24H.next(r, 1000);
            int service_hash = HashUtil.hash(serviceName);
            long txid = KeyGen.next();
            Service24H.profile(txid, service_hash);
            long endtime = Service24H.getEndTime();
            int elapsed = Service24H.next(r, 10000);
            int cpu = Service24H.next(r, 10000);
            int sqlCount = Service24H.next(r, 100);
            int sqlTime = Service24H.next(r, 1000);
            String remoteAddr = IPUtil.toString(DataOutputX.toBytes(Service24H.next(r, 255)));
            String error = null;
            long visitor = KeyGen.next();
            XLogPack pack = TraceMain.txperf(endtime, txid, service_hash, serviceName, elapsed, cpu, sqlCount, sqlTime, remoteAddr, error, visitor);
            TraceMain.metering(pack);
            long unit = endtime / 5000L;
            if (last_unit != unit) {
                last_unit = unit;
                System.out.println(DateUtil.timestamp(endtime) + "  exe-tx=" + txcount + "  " + Configure.getInstance().getObjName());
            }
            if (!((tm += interval) > 1.0)) continue;
            ThreadUtil.sleep((int)tm);
            tm -= (double)((int)tm);
        } while ((x = System.currentTimeMillis()) - now <= 3000000L);
        ThreadUtil.sleep(100000L);
    }

    private static long getEndTime() {
        if (stack.size() == 0) {
            for (int i = 0; i < 24; ++i) {
                for (int j = 0; j < rate[i]; ++j) {
                    stack.add(i);
                }
            }
        }
        int h = stack.pop();
        return time + (long)(h * 3600) * 1000L + (long)r.nextInt(3600) * 1000L;
    }

    private static void profile(long txid, int serviceHash) {
        TraceContext ctx = new TraceContext(false);
        ctx.txid = txid;
        ctx.serviceHash = serviceHash;
        ctx.startTime = System.currentTimeMillis();
        long key = TraceContextManager.start(Thread.currentThread(), ctx);
        AnyTrace.message("profile 1");
        AnyTrace.message("profile 2");
        ctx.profile.close(true);
        TraceContextManager.end(key);
    }

    private static int next(Random r, int max) {
        return Math.abs(r.nextInt() % max);
    }
}

