/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import scouter.util.BytesMap;
import scouter.util.FileUtil;

public class BytesClassLoader
extends ClassLoader {
    private BytesMap bytes;

    public BytesClassLoader(BytesMap bytes) {
        this(bytes, null);
    }

    public BytesClassLoader(BytesMap bytes, ClassLoader parent) {
        super(parent);
        this.bytes = bytes;
    }

    public BytesClassLoader(byte[] jarBytes) {
        this(jarBytes, null);
    }

    public BytesClassLoader(byte[] jarBytes, ClassLoader parent) {
        super(parent);
        this.bytes = this.load(jarBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected BytesMap load(byte[] bytes) {
        BytesMap bmap = new BytesMap();
        JarInputStream jar = null;
        try {
            jar = new JarInputStream(new ByteArrayInputStream(bytes));
            JarEntry ent = jar.getNextJarEntry();
            while (ent != null) {
                byte[] buff = FileUtil.readAll(jar);
                if (buff != null) {
                    bmap.put(ent.getName(), buff);
                }
                ent = jar.getNextJarEntry();
            }
        }
        catch (Exception exception) {
            FileUtil.close(jar);
            catch (Throwable throwable) {
                FileUtil.close(jar);
                throw throwable;
            }
        }
        FileUtil.close(jar);
        return bmap;
    }

    @Override
    protected Class<?> findClass(String classname) throws ClassNotFoundException {
        String name = classname.replace('.', '/') + ".class";
        byte[] b = this.bytes.getBytes(name);
        if (b == null) {
            throw new ClassNotFoundException("not found class " + classname);
        }
        return this.defineClass(classname, b, 0, b.length, null);
    }

    @Override
    protected URL findResource(String name) {
        return this.bytes.getResource(name);
    }
}

