/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.TraceSQL;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

class DbcOpenMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE_SQL = TraceSQL.class.getName().replace('.', '/');
    private static final String START_METHOD = "dbcOpenStart";
    private static final String START_SIGNATURE = "(ILjava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String END_METHOD = "dbcOpenEnd";
    private static final String END_SIGNATURE = "(Ljava/sql/Connection;Ljava/lang/Object;)Ljava/sql/Connection;";
    private static final String END_SIGNATURE2 = "(Ljava/lang/Object;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private int fullname_hash;
    private String fullname;
    private int statIdx;
    private boolean isStatic = false;

    public DbcOpenMV(int access, String desc, MethodVisitor mv, String fullname, int fullname_hash) {
        super(327680, access, desc, mv);
        this.fullname = fullname;
        this.fullname_hash = fullname_hash;
        this.isStatic = (access & 8) != 0;
    }

    @Override
    public void visitCode() {
        AsmUtil.PUSH(this.mv, this.fullname_hash);
        this.mv.visitLdcInsn(this.fullname);
        if (this.isStatic) {
            AsmUtil.PUSHNULL(this.mv);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitMethodInsn(184, TRACE_SQL, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE, false);
        }
        this.mv.visitInsn(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE2, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

