/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.HashSet;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.asm.IASM;
import scouter.agent.asm.ResultSetCV;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class JDBCResultSetASM
implements IASM,
Opcodes {
    public final HashSet<String> target;
    public final HashSet<String> onlyCloseTarget;
    public final HashSet<String> onlyNextTarget;

    public JDBCResultSetASM() {
        this.target = HookingSet.getHookingClassSet(Configure.getInstance().hook_jdbc_rs_classes);
        this.onlyCloseTarget = new HashSet();
        this.onlyNextTarget = new HashSet();
        this.target.add("org/mariadb/jdbc/MySQLResultSet");
        this.target.add("org/mariadb/jdbc/internal/queryresults/resultset/MariaSelectResultSet");
        this.target.add("org/mariadb/jdbc/internal/com/read/resultset/SelectResultSet");
        this.target.add("org/mariadb/jdbc/internal/com/read/resultset/UpdatableResultSet");
        this.target.add("oracle/jdbc/driver/OracleResultSetImpl");
        this.target.add("com/mysql/jdbc/ResultSetImpl");
        this.target.add("org/postgresql/jdbc2/AbstractJdbc2ResultSet");
        this.target.add("org/postgresql/jdbc/PgResultSet");
        this.target.add("org/apache/derby/client/am/ResultSet");
        this.target.add("jdbc/FakeResultSet");
        this.target.add("net/sourceforge/jtds/jdbc/JtdsResultSet");
        this.target.add("com/microsoft/sqlserver/jdbc/SQLServerResultSet");
        this.target.add("oracle/jdbc/driver/InsensitiveScrollableResultSet");
        this.target.add("oracle/jdbc/driver/SensitiveScrollableResultSet");
        this.target.add("org/hsqldb/jdbc/JDBCResultSet");
        this.target.add("cubrid/jdbc/driver/CUBRIDResultSet");
        this.target.add("org/mariadb/jdbc/MariaDbResultSet");
        this.target.add("com/tmax/tibero/jdbc/TbResultSetBase");
        this.target.add("com/tmax/tibero/jdbc/driver/TbResultSetBase");
        String alti1 = "Altibase/jdbc/driver/AltibaseResultSet";
        this.target.add(alti1);
        this.onlyCloseTarget.add(alti1);
        String alti2 = "Altibase/jdbc/driver/AltibaseEmptyResultSet";
        String alti3 = "Altibase/jdbc/driver/AltibaseForwardOnlyResultSet";
        String alti4 = "Altibase/jdbc/driver/AltibaseScrollInsensitiveResultSet";
        String alti5 = "Altibase/jdbc/driver/AltibaseLightWeightResultSet";
        String alti6 = "Altibase/jdbc/driver/AltibaseTempResultSet";
        String alti7 = "Altibase/jdbc/driver/AltibaseUpdatableResultSet";
        this.target.add(alti2);
        this.onlyNextTarget.add(alti2);
        this.target.add(alti3);
        this.onlyNextTarget.add(alti3);
        this.target.add(alti4);
        this.onlyNextTarget.add(alti4);
        this.target.add(alti5);
        this.onlyNextTarget.add(alti5);
        this.target.add(alti6);
        this.onlyNextTarget.add(alti6);
        this.target.add(alti7);
        this.onlyNextTarget.add(alti7);
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_dbsql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("A107", "jdbc rs found: " + className);
        Scope scope = Scope.ALL;
        if (this.onlyCloseTarget.contains(className)) {
            scope = Scope.ONLYINIT;
        } else if (this.onlyNextTarget.contains(className)) {
            scope = Scope.ONLYNEXT;
        }
        return new ResultSetCV(cv, scope);
    }

    protected static enum Scope {
        ALL,
        ONLYINIT,
        ONLYNEXT;

    }
}

