/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.anotation.Counter;
import scouter.agent.netio.data.DataProxy;
import scouter.lang.pack.PerfCounterPack;
import scouter.util.ThreadUtil;
import scouter.util.scan.Scanner;

public class CounterExecutingManager
extends Thread {
    private static CounterExecutingManager instance;
    Configure conf = Configure.getInstance();
    private List<CountStat> taskSec = new ArrayList<CountStat>();

    public static final synchronized CounterExecutingManager getInstance() {
        if (instance == null) {
            instance = new CounterExecutingManager();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    @Override
    public void run() {
        while (true) {
            ThreadUtil.sleep(1000L);
            if (!this.conf.counter_enabled) continue;
            long now = System.currentTimeMillis();
            CounterBasket pw = new CounterBasket();
            for (int i = 0; i < this.taskSec.size(); ++i) {
                CountStat r = this.taskSec.get(i);
                try {
                    if (r.counter.interval() > now - r.xtime) continue;
                    r.xtime = now;
                    r.counter.process(pw);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            PerfCounterPack[] pks = pw.getList();
            DataProxy.sendCounter(pks);
        }
    }

    private CounterExecutingManager() {
    }

    public void put(Invocation counter) {
        this.taskSec.add(new CountStat(counter));
    }

    public static void load() {
        Set<String> defaultTasks = new Scanner("scouter.agent.counter.task").process();
        Set<String> customTasks = new Scanner(System.getProperty("scouter.task")).process();
        defaultTasks.addAll(customTasks);
        int n = 0;
        Iterator<String> itr = defaultTasks.iterator();
        while (itr.hasNext()) {
            try {
                Class<?> c = Class.forName(itr.next());
                if (!Modifier.isPublic(c.getModifiers())) continue;
                Method[] m = c.getDeclaredMethods();
                for (int i = 0; i < m.length; ++i) {
                    Counter mapAn = m[i].getAnnotation(Counter.class);
                    if (mapAn == null) continue;
                    int interval = mapAn.interval();
                    CounterExecutingManager.getInstance().put(new Invocation(c.newInstance(), m[i], interval));
                    ++n;
                }
            }
            catch (Throwable t) {
                Logger.println("A112", ThreadUtil.getStackTrace(t));
            }
        }
        Logger.println("A113", "Counter Collector Started (#" + n + ")");
    }

    public static void main(String[] args) {
        CounterExecutingManager.load();
    }

    protected static class Invocation {
        Object object;
        Method method;
        long time;

        public Invocation(Object object, Method method, long interval) {
            this.object = object;
            this.method = method;
            this.time = interval;
        }

        public void process(CounterBasket pw) throws Throwable {
            try {
                this.method.invoke(this.object, pw);
            }
            catch (Exception e) {
                Logger.println("A111", this.object.getClass() + " " + this.method + " " + e);
            }
        }

        public long interval() {
            return this.time;
        }
    }

    static class CountStat {
        Invocation counter;
        long xtime;

        CountStat(Invocation counter) {
            this.counter = counter;
        }
    }
}

