/*
 * Decompiled with CFR 0.152.
 */
package scouter.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Generator {
    public static void main(String[] args) throws Exception {
        String className = "ScouterResultSet";
        String superName = null;
        String innerName = "java.sql.ResultSet";
        Class<?> target = Class.forName(innerName);
        if (superName == null) {
            System.out.println("public class " + className + " implements " + innerName + " {");
        } else {
            System.out.println("public class " + className + " extends " + superName + " implements " + innerName + " {");
        }
        System.out.println("    " + innerName + " inner;");
        System.out.println("    public " + className + "(" + innerName + " inner){");
        if (superName != null) {
            System.out.println("           super(inner);");
        }
        System.out.println("           this.inner=inner;");
        System.out.println("    }");
        Method[] m = target.getMethods();
        for (int i = 0; i < m.length; ++i) {
            boolean isVoid = m[i].getReturnType().toString().endsWith("void");
            System.out.println("    " + Generator.getMethodString(m[i]) + "{");
            System.out.println("        " + Generator.getInnerString(m[i]));
            System.out.println("    }");
        }
        System.out.println("}");
    }

    public static String getMethodString(Method m) {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = m.getModifiers();
            if (mod != 0) {
                if (Modifier.isAbstract(mod)) {
                    mod ^= 0x400;
                }
                sb.append("final " + Modifier.toString(mod)).append(" ");
            }
            sb.append(Generator.getTypeName(m.getReturnType())).append(' ');
            sb.append(m.getName()).append('(');
            Class<?>[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(Generator.getTypeName(params[j]) + " a" + j);
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            Class<?>[] exceptions = m.getExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k].getName());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(',');
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public static String getInnerString(Method m) {
        try {
            boolean isVoid = Generator.getTypeName(m.getReturnType()).equals("void");
            StringBuilder sb = new StringBuilder();
            if (!isVoid) {
                sb.append("return ");
            }
            sb.append("this.inner.");
            sb.append(m.getName()).append('(');
            Class<?>[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append("a" + j);
                if (j >= params.length - 1) continue;
                sb.append(", ");
            }
            sb.append(");");
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }
}

