/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import java.sql.Timestamp;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.lang.value.MapValue;
import scouter.util.Hexa32;

public class ObjectPack
implements Pack {
    public String objType;
    public int objHash;
    public String objName;
    public String address;
    public String version;
    public boolean alive = true;
    public long wakeup;
    public MapValue tags = new MapValue();
    public transient int updated;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OBJECT ");
        sb.append(" objType=").append(this.objType);
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" objName=").append(this.objName);
        if (this.isOk(this.address)) {
            sb.append(" addr=").append(this.address);
        }
        if (this.isOk(this.version)) {
            sb.append(" ").append(this.version);
        }
        if (this.alive) {
            sb.append(" alive");
        }
        if (this.wakeup > 0L) {
            sb.append(" ").append(new Timestamp(this.wakeup));
        }
        if (this.tags.size() > 0) {
            sb.append(" ").append(this.tags);
        }
        return sb.toString();
    }

    private boolean isOk(String s) {
        return s != null && s.length() > 0;
    }

    public void wakeup() {
        this.wakeup = System.currentTimeMillis();
        this.alive = true;
    }

    @Override
    public byte getPackType() {
        return 80;
    }

    @Override
    public void write(DataOutputX dout) throws IOException {
        dout.writeText(this.objType);
        dout.writeDecimal(this.objHash);
        dout.writeText(this.objName);
        dout.writeText(this.address);
        dout.writeText(this.version);
        dout.writeBoolean(this.alive);
        dout.writeDecimal(this.wakeup);
        dout.writeValue(this.tags);
    }

    @Override
    public Pack read(DataInputX din) throws IOException {
        this.objType = din.readText();
        this.objHash = (int)din.readDecimal();
        this.objName = din.readText();
        this.address = din.readText();
        this.version = din.readText();
        this.alive = din.readBoolean();
        this.wakeup = din.readDecimal();
        this.tags = (MapValue)din.readValue();
        return this;
    }

    public int hashCode() {
        return this.objHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.objHash == ((ObjectPack)obj).objHash;
    }
}

