/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.util.Properties;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.util.IClose;

public class FileUtil {
    public static DatagramSocket close(DatagramSocket udp) {
        try {
            if (udp != null) {
                udp.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static InputStream close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static OutputStream close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Reader close(Reader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Writer close(Writer out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static byte[] readAll(InputStream fin) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int n = fin.read(buff);
        while (n >= 0) {
            out.write(buff, 0, n);
            n = fin.read(buff);
        }
        return out.toByteArray();
    }

    public static IClose close(IClose object) {
        try {
            if (object != null) {
                object.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static RandomAccessFile close(RandomAccessFile raf) {
        try {
            if (raf != null) {
                raf.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Socket close(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static ServerSocket close(ServerSocket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void save(String file, byte[] b) {
        FileUtil.save(new File(file), b);
    }

    public static void save(File file, byte[] byteArray) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(byteArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveText(File file, String contents) {
        block6: {
            boolean bl;
            FileOutputStream out = null;
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                out = new FileOutputStream(file);
                ((OutputStream)out).write(contents.getBytes());
                bl = true;
                FileUtil.close(out);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                FileUtil.close(out);
            }
            return bl;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] readAll(File file) {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byArray = FileUtil.readAll(in);
        }
        catch (Exception exception) {
            FileUtil.close(in);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            throw throwable;
        }
        FileUtil.close(in);
        return byArray;
    }

    public static void copy(File src, File dest) {
        try {
            FileUtil.copy(src, dest, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File src, File dest, boolean overwrite) throws IOException {
        block16: {
            long fileSize;
            block15: {
                File destDir;
                if (!src.isFile() || !src.exists()) {
                    return false;
                }
                if (dest.exists()) {
                    if (dest.isDirectory()) {
                        dest = new File(dest, src.getName());
                    } else if (dest.isFile()) {
                        if (!overwrite) {
                            throw new IOException(dest.getAbsolutePath() + "' already exists!");
                        }
                    } else {
                        throw new IOException("Invalid  file '" + dest.getAbsolutePath() + "'");
                    }
                }
                if (!(destDir = dest.getParentFile()).exists() && !destDir.mkdirs()) {
                    throw new IOException("Failed to create " + destDir.getAbsolutePath());
                }
                fileSize = src.length();
                if (fileSize <= 0x1400000L) break block15;
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(src);
                    out = new FileOutputStream(dest);
                    int done = 0;
                    int buffLen = 32768;
                    byte[] buf = new byte[buffLen];
                    while ((done = in.read(buf, 0, buffLen)) >= 0) {
                        if (done == 0) {
                            Thread.yield();
                            continue;
                        }
                        out.write(buf, 0, done);
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    FileUtil.close(out);
                    throw throwable;
                }
                FileUtil.close(in);
                FileUtil.close(out);
                break block16;
            }
            FileInputStream in = null;
            FileOutputStream out = null;
            FileChannel fin = null;
            FileChannel fout = null;
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(dest);
                fin = in.getChannel();
                fout = out.getChannel();
                long position = 0L;
                long done = 0L;
                long count = Math.min(65536L, fileSize);
                do {
                    done = fin.transferTo(position, count, fout);
                    position += done;
                } while ((fileSize -= done) > 0L);
            }
            catch (Throwable throwable) {
                FileUtil.close(fin);
                FileUtil.close(fout);
                FileUtil.close(in);
                FileUtil.close(out);
                throw throwable;
            }
            FileUtil.close(fin);
            FileUtil.close(fout);
            FileUtil.close(in);
            FileUtil.close(out);
        }
        return true;
    }

    public static FileChannel close(FileChannel fc) {
        if (fc != null) {
            try {
                fc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getJarLocation(Class class1) {
        try {
            String path = "" + class1.getResource("/" + class1.getName().replace('.', '/') + ".class");
            if (path.indexOf("!") < 0) {
                return null;
            }
            path = path.substring("jar:file:".length(), path.indexOf("!"));
            path = path.substring(0, path.lastIndexOf(47));
            return new File(path).getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJarFileName(Class class1) {
        try {
            String path = "" + class1.getResource("/" + class1.getName().replace('.', '/') + ".class");
            if (path.indexOf("!") < 0) {
                return null;
            }
            path = path.substring("jar:file:".length(), path.indexOf("!"));
            return new File(path).getAbsolutePath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        String path = FileUtil.getJarLocation(FileUtil.class);
        System.out.println(path);
        new File(path, "test.txt").createNewFile();
        System.out.println(new File(path).canWrite());
        System.out.println(new File(path).getAbsolutePath());
    }

    public static void close(DataInputX in) {
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(DataOutputX out) {
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String load(File file, String enc) {
        block6: {
            String string;
            if (file == null || !file.canRead()) {
                return null;
            }
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                string = new String(FileUtil.readAll(in), enc);
                FileUtil.close(in);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                FileUtil.close(in);
            }
            return string;
        }
        return null;
    }

    public static void append(String file, String line) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file, true));
            out.println(line);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileUtil.close(out);
    }

    public static boolean mkdirs(String path) {
        File f = new File(path);
        if (!f.exists()) {
            return f.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(File f) {
        BufferedInputStream reader = null;
        Properties p = new Properties();
        try {
            reader = new BufferedInputStream(new FileInputStream(f));
            p.load(reader);
        }
        catch (Exception exception) {
            FileUtil.close(reader);
        }
        catch (Throwable throwable) {
            FileUtil.close(reader);
            throw throwable;
        }
        FileUtil.close(reader);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(File f, Properties p) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(f);
            p.list(pw);
        }
        catch (Exception exception) {
            FileUtil.close(pw);
        }
        catch (Throwable throwable) {
            FileUtil.close(pw);
            throw throwable;
        }
        FileUtil.close(pw);
    }
}

