/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.asm.util.AsmUtil;
import scouter.agent.trace.TraceMain;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

class CapArgsMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String CLASS = TraceMain.class.getName().replace('.', '/');
    private static final String METHOD = "capArgs";
    private static final String SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V";
    private Type[] paramTypes;
    private boolean isStatic;
    private String className;
    private String methodName;
    private String methodDesc;

    public CapArgsMV(int access, String desc, MethodVisitor mv, Type[] paramTypes, boolean isStatic, String classname, String methodname, String methoddesc) {
        super(524288, access, desc, mv);
        this.paramTypes = paramTypes;
        this.isStatic = isStatic;
        this.className = classname;
        this.methodName = methodname;
        this.methodDesc = methoddesc;
    }

    @Override
    public void visitCode() {
        int sidx = this.isStatic ? 0 : 1;
        int arrVarIdx = this.newLocal(Type.getType("[Ljava/lang/Object;"));
        AsmUtil.PUSH(this.mv, this.paramTypes.length);
        this.mv.visitTypeInsn(189, "java/lang/Object");
        this.mv.visitVarInsn(58, arrVarIdx);
        for (int i = 0; i < this.paramTypes.length; ++i) {
            Type type = this.paramTypes[i];
            this.mv.visitVarInsn(25, arrVarIdx);
            AsmUtil.PUSH(this.mv, i);
            switch (type.getSort()) {
                case 1: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    this.mv.visitVarInsn(21, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 7: {
                    this.mv.visitVarInsn(22, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 6: {
                    this.mv.visitVarInsn(23, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 8: {
                    this.mv.visitVarInsn(24, sidx);
                    this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
                default: {
                    this.mv.visitVarInsn(25, sidx);
                }
            }
            this.mv.visitInsn(83);
            sidx += type.getSize();
        }
        AsmUtil.PUSH(this.mv, this.className);
        AsmUtil.PUSH(this.mv, this.methodName);
        AsmUtil.PUSH(this.mv, this.methodDesc);
        if (this.isStatic) {
            AsmUtil.PUSHNULL(this.mv);
        } else {
            this.mv.visitVarInsn(25, 0);
        }
        this.mv.visitVarInsn(25, arrVarIdx);
        this.mv.visitMethodInsn(184, CLASS, METHOD, SIGNATURE, false);
        this.mv.visitCode();
    }
}

