/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.mongodb;

import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.trace.TraceMongoDB;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.FieldVisitor;
import scouter.org.objectweb.asm.Label;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

public class MongoCommandProtocolASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf.hook_mongodb_enabled) {
            return cv;
        }
        if ("com/mongodb/internal/connection/CommandProtocolImpl".equals(className) || "com/mongodb/connection/CommandProtocolImpl".equals(className)) {
            return new MongoCommandProtocolCV(cv, className);
        }
        return cv;
    }

    static class ExecuteMV
    extends LocalVariablesSorter
    implements Opcodes {
        private static final String TRACE = TraceMongoDB.class.getName().replace('.', '/');
        private static final String METHOD = "startExecute";
        private static final String SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;";
        private static final String END_METHOD = "endExecute";
        private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Throwable;)V";
        private String className;
        boolean namespace;
        boolean command;
        boolean readPreference;
        boolean payload;
        String version;
        private int statIdx;
        private Label startFinally = new Label();

        public ExecuteMV(int access, String desc, MethodVisitor mv, String className, boolean namespace, boolean command, boolean readPreference, boolean payload, String version) {
            super(524288, access, desc, mv);
            this.className = className;
            this.namespace = namespace;
            this.command = command;
            this.readPreference = readPreference;
            this.payload = payload;
            this.version = version;
        }

        @Override
        public void visitCode() {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            if (this.namespace) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.className, "namespace", "Lcom/mongodb/MongoNamespace;");
            } else {
                this.mv.visitInsn(1);
            }
            if (this.command) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.className, "command", "Lorg/bson/BsonDocument;");
            } else {
                this.mv.visitInsn(1);
            }
            if (this.readPreference) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.className, "readPreference", "Lcom/mongodb/ReadPreference;");
            } else {
                this.mv.visitInsn(1);
            }
            if (this.payload) {
                this.mv.visitVarInsn(25, 0);
                if (this.version.equals("v405")) {
                    this.mv.visitFieldInsn(180, this.className, "payload", "Lcom/mongodb/internal/connection/SplittablePayload;");
                } else {
                    this.mv.visitFieldInsn(180, this.className, "payload", "Lcom/mongodb/connection/SplittablePayload;");
                }
            } else {
                this.mv.visitInsn(1);
            }
            this.mv.visitLdcInsn(this.version);
            this.mv.visitMethodInsn(184, TRACE, METHOD, SIGNATURE, false);
            this.statIdx = this.newLocal(Type.getType(Object.class));
            this.mv.visitVarInsn(58, this.statIdx);
            this.mv.visitLabel(this.startFinally);
            this.mv.visitCode();
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode >= 172 && opcode <= 177) {
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitInsn(1);
                this.mv.visitMethodInsn(184, TRACE, END_METHOD, END_SIGNATURE, false);
            }
            this.mv.visitInsn(opcode);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            Label endFinally = new Label();
            this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
            this.mv.visitLabel(endFinally);
            this.mv.visitInsn(89);
            int errIdx = this.newLocal(Type.getType(Throwable.class));
            this.mv.visitVarInsn(58, errIdx);
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitVarInsn(25, errIdx);
            this.mv.visitMethodInsn(184, TRACE, END_METHOD, END_SIGNATURE, false);
            this.mv.visitInsn(191);
            this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
        }
    }

    static class ExecuteAsyncMV
    extends LocalVariablesSorter
    implements Opcodes {
        private static final String TRACE = TraceMongoDB.class.getName().replace('.', '/');
        private static final String METHOD = "startExecuteAsync";
        private static final String SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;";
        private String className;
        boolean namespace;
        boolean command;
        boolean readPreference;
        boolean payload;
        String version;

        public ExecuteAsyncMV(int access, String desc, MethodVisitor mv, String className, boolean namespace, boolean command, boolean readPreference, boolean payload, String version) {
            super(524288, access, desc, mv);
            this.className = className;
            this.namespace = namespace;
            this.command = command;
            this.readPreference = readPreference;
            this.payload = payload;
            this.version = version;
        }

        @Override
        public void visitCode() {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            if (this.namespace) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.className, "namespace", "Lcom/mongodb/MongoNamespace;");
            } else {
                this.mv.visitInsn(1);
            }
            if (this.command) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.className, "command", "Lorg/bson/BsonDocument;");
            } else {
                this.mv.visitInsn(1);
            }
            if (this.readPreference) {
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, this.className, "readPreference", "Lcom/mongodb/ReadPreference;");
            } else {
                this.mv.visitInsn(1);
            }
            if (this.payload) {
                this.mv.visitVarInsn(25, 0);
                if (this.version.equals("v405")) {
                    this.mv.visitFieldInsn(180, this.className, "payload", "Lcom/mongodb/internal/connection/SplittablePayload;");
                } else {
                    this.mv.visitFieldInsn(180, this.className, "payload", "Lcom/mongodb/connection/SplittablePayload;");
                }
            } else {
                this.mv.visitInsn(1);
            }
            this.mv.visitVarInsn(25, 2);
            this.mv.visitLdcInsn(this.version);
            this.mv.visitMethodInsn(184, TRACE, METHOD, SIGNATURE, false);
            if (this.version.equals("v405")) {
                this.mv.visitTypeInsn(192, "com/mongodb/internal/async/SingleResultCallback");
            } else {
                this.mv.visitTypeInsn(192, "com/mongodb/async/SingleResultCallback");
            }
            this.mv.visitVarInsn(58, 2);
            this.mv.visitCode();
        }
    }

    static class MongoCommandProtocolCV
    extends ClassVisitor
    implements Opcodes {
        public String className;
        boolean namespace;
        boolean command;
        boolean readPreference;
        boolean payload;
        String version = "v405";

        public MongoCommandProtocolCV(ClassVisitor cv, String className) {
            super(524288, cv);
            this.className = className;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            int newAccess = access;
            if ((access & 1) == 0) {
                newAccess = access | 1;
            }
            super.visit(version, newAccess, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            int newAccess = access;
            if ((access & 1) == 0) {
                newAccess = access | 1;
            }
            if (name.equals("namespace") && descriptor.equals("Lcom/mongodb/MongoNamespace;")) {
                this.namespace = true;
            } else if (name.equals("command") && descriptor.equals("Lorg/bson/BsonDocument;")) {
                this.command = true;
            } else if (name.equals("readPreference") && descriptor.equals("Lcom/mongodb/ReadPreference;")) {
                this.readPreference = true;
            } else if (name.equals("payload") && (descriptor.equals("Lcom/mongodb/internal/connection/SplittablePayload;") || descriptor.equals("Lcom/mongodb/connection/SplittablePayload;"))) {
                this.payload = true;
                if (descriptor.equals("Lcom/mongodb/connection/SplittablePayload;")) {
                    this.version = "v382";
                }
            }
            return super.visitField(newAccess, name, descriptor, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null) {
                return mv;
            }
            if ("executeAsync".equals(name) && desc.startsWith("(Lcom/mongodb/internal/connection/InternalConnection;Lcom/mongodb/internal/async/SingleResultCallback;)V")) {
                return new ExecuteAsyncMV(access, desc, mv, this.className, this.namespace, this.command, this.readPreference, this.payload, "v405");
            }
            if ("executeAsync".equals(name) && desc.startsWith("(Lcom/mongodb/internal/connection/InternalConnection;Lcom/mongodb/async/SingleResultCallback;)V")) {
                return new ExecuteAsyncMV(access, desc, mv, this.className, this.namespace, this.command, this.readPreference, this.payload, "v382");
            }
            if ("execute".equals(name) && desc.startsWith("(Lcom/mongodb/internal/connection/InternalConnection;)")) {
                return new ExecuteMV(access, desc, mv, this.className, this.namespace, this.command, this.readPreference, this.payload, this.version);
            }
            if ("execute".equals(name) && desc.startsWith("(Lcom/mongodb/connection/InternalConnection;)")) {
                return new ExecuteMV(access, desc, mv, this.className, this.namespace, this.command, this.readPreference, this.payload, "v364");
            }
            return mv;
        }
    }
}

