/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.data;

import java.util.ArrayList;
import java.util.List;
import scouter.agent.Configure;
import scouter.agent.netio.data.net.DataUdpAgent;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.util.Queue;
import scouter.util.ThreadUtil;

public class UDPDataSendThread
extends Thread {
    private static UDPDataSendThread instance = null;
    private Queue<byte[]> queue = new Queue(1024);
    private boolean running = true;
    private Configure conf = Configure.getInstance();

    public static final synchronized UDPDataSendThread getInstance() {
        if (instance == null) {
            instance = new UDPDataSendThread();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName(instance));
            instance.start();
        }
        return instance;
    }

    protected UDPDataSendThread() {
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public boolean add(Pack p) {
        try {
            byte[] b = new DataOutputX().writePack(p).toByteArray();
            byte[] ok = this.queue.push(b);
            return ok != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isQueueOk() {
        return this.queue.size() < 1000;
    }

    public void shutdown() {
        this.running = false;
    }

    @Override
    public void run() {
        DataUdpAgent udp = DataUdpAgent.getInstance();
        block4: while (this.running) {
            int size = this.queue.size();
            switch (size) {
                case 0: {
                    ThreadUtil.sleep(this.conf.net_udp_collection_interval_ms);
                    continue block4;
                }
                case 1: {
                    udp.write(this.queue.pop());
                    continue block4;
                }
            }
            this.send(udp, size);
        }
    }

    private void send(DataUdpAgent udp, int size) {
        ArrayList<byte[]> buff = new ArrayList<byte[]>();
        int bytes = 0;
        for (int k = 0; k < size; ++k) {
            byte[] b = this.queue.pop();
            if (bytes + b.length >= this.conf.net_udp_packet_max_bytes) {
                this.send(udp, buff);
                bytes = 0;
                buff.clear();
            }
            bytes += b.length;
            buff.add(b);
        }
        this.send(udp, buff);
    }

    public void send(DataUdpAgent udp, List<byte[]> buff) {
        switch (buff.size()) {
            case 0: {
                break;
            }
            case 1: {
                udp.write(buff.get(0));
                break;
            }
            default: {
                udp.write(buff);
            }
        }
    }
}

