/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.elasticsearch;

import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.trace.TraceElasticSearch;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;

public class RestClientASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf._hook_elasticsearch_enabled) {
            return cv;
        }
        if ("org/elasticsearch/client/RestClient".equals(className)) {
            return new RestClientCV(cv, className);
        }
        if ("org/elasticsearch/client/RequestLogger".equals(className)) {
            return new RequestLoggerCV(cv, className);
        }
        return cv;
    }

    static class RequestLoggerCV
    extends ClassVisitor
    implements Opcodes {
        public String className;

        public RequestLoggerCV(ClassVisitor cv, String className) {
            super(589824, cv);
            this.className = className;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null) {
                return mv;
            }
            if ("logResponse".equals(name) && desc.startsWith("(Lorg/apache/commons/logging/Log;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/HttpHost;Lorg/apache/http/HttpResponse;")) {
                return new RequestLoggerMV(access, desc, mv, this.className);
            }
            if ("logFailedRequest".equals(name) && desc.startsWith("(Lorg/apache/commons/logging/Log;Lorg/apache/http/client/methods/HttpUriRequest;Lorg/elasticsearch/client/Node;Ljava/lang/Exception;")) {
                return new RequestFailLoggerMV(access, desc, mv, this.className);
            }
            return mv;
        }

        static class RequestFailLoggerMV
        extends LocalVariablesSorter
        implements Opcodes {
            private static final String TRACE = TraceElasticSearch.class.getName().replace('.', '/');
            private static final String METHOD = "endFailRequest";
            private static final String SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Exception;)V";
            private String className;

            public RequestFailLoggerMV(int access, String desc, MethodVisitor mv, String className) {
                super(589824, access, desc, mv);
                this.className = className;
            }

            @Override
            public void visitCode() {
                this.mv.visitVarInsn(25, 1);
                this.mv.visitVarInsn(25, 2);
                this.mv.visitVarInsn(25, 3);
                this.mv.visitMethodInsn(184, TRACE, METHOD, SIGNATURE, false);
                this.mv.visitCode();
            }
        }

        static class RequestLoggerMV
        extends LocalVariablesSorter
        implements Opcodes {
            private static final String TRACE = TraceElasticSearch.class.getName().replace('.', '/');
            private static final String METHOD = "endRequest";
            private static final String SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V";
            private String className;

            public RequestLoggerMV(int access, String desc, MethodVisitor mv, String className) {
                super(589824, access, desc, mv);
                this.className = className;
            }

            @Override
            public void visitCode() {
                this.mv.visitVarInsn(25, 1);
                this.mv.visitVarInsn(25, 2);
                this.mv.visitVarInsn(25, 3);
                this.mv.visitMethodInsn(184, TRACE, METHOD, SIGNATURE, false);
                this.mv.visitCode();
            }
        }
    }

    static class RestClientStartMV
    extends LocalVariablesSorter
    implements Opcodes {
        private static final String TRACE = TraceElasticSearch.class.getName().replace('.', '/');
        private static final String METHOD = "startRequest";
        private static final String SIGNATURE = "(Ljava/lang/Object;)V";
        private String className;

        public RestClientStartMV(int access, String desc, MethodVisitor mv, String className) {
            super(589824, access, desc, mv);
            this.className = className;
        }

        @Override
        public void visitCode() {
            this.mv.visitVarInsn(25, 4);
            this.mv.visitMethodInsn(184, TRACE, METHOD, SIGNATURE, false);
            this.mv.visitCode();
        }
    }

    static class RestClientCV
    extends ClassVisitor
    implements Opcodes {
        public String className;

        public RestClientCV(ClassVisitor cv, String className) {
            super(589824, cv);
            this.className = className;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null) {
                return mv;
            }
            if ("performRequestAsync".equals(name) && desc.startsWith("(JLorg/elasticsearch/client/RestClient$NodeTuple;Lorg/apache/http/client/methods/HttpRequestBase;")) {
                return new RestClientStartMV(access, desc, mv, this.className);
            }
            return mv;
        }
    }
}

