/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.jmx;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import scouter.agent.Logger;
import scouter.agent.ObjTypeDetector;
import scouter.util.StringIntMap;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class LazyPlatformMBeanServer {
    private static volatile LazyPlatformMBeanServer instance;
    private MBeanServer platformMBeanServer;
    private final boolean waitForContainerToCreatePlatformMBeanServer;
    Map<String, ObjectName> objectNameMap = new HashMap<String, ObjectName>();
    Set<String> ignoreSet = new HashSet<String>();
    StringIntMap tryCountMap = new StringIntMap();

    public static synchronized LazyPlatformMBeanServer create() {
        if (instance == null) {
            instance = new LazyPlatformMBeanServer();
        }
        return instance;
    }

    private LazyPlatformMBeanServer() {
        this.waitForContainerToCreatePlatformMBeanServer = "jboss".equals(ObjTypeDetector.objType) || "weblogic".equals(ObjTypeDetector.objType) || "websphere".equals(ObjTypeDetector.objType);
    }

    public boolean checkInit() throws Exception {
        if (this.platformMBeanServer != null) {
            return true;
        }
        if (this.waitForContainerToCreatePlatformMBeanServer) {
            String platformMBeanServerFieldName = SystemUtil.IS_JAVA_IBM ? "platformServer" : "platformMBeanServer";
            Field platformMBeanServerField = ManagementFactory.class.getDeclaredField(platformMBeanServerFieldName);
            platformMBeanServerField.setAccessible(true);
            if (platformMBeanServerField.get(null) != null) {
                this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                this.registerHotspotMbean(this.platformMBeanServer);
                return true;
            }
        } else {
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerHotspotMbean(this.platformMBeanServer);
            return true;
        }
        return false;
    }

    private void registerHotspotMbean(MBeanServer mbeanServer) throws Exception {
        Class<?> sunManagementFactoryHelperClass = Class.forName("sun.management.ManagementFactoryHelper");
        Method registerInternalMBeansMethod = sunManagementFactoryHelperClass.getDeclaredMethod("registerInternalMBeans", MBeanServer.class);
        registerInternalMBeansMethod.setAccessible(true);
        registerInternalMBeansMethod.invoke(null, mbeanServer);
    }

    public float getValue(String mbean, String attribute) throws Exception {
        if (!this.checkInit()) {
            return -1.0f;
        }
        if (this.ignoreSet.contains(mbean)) {
            return -1.0f;
        }
        String key = mbean + attribute;
        if (this.ignoreSet.contains(key)) {
            return -1.0f;
        }
        ObjectName objectName = this.objectNameMap.get(mbean);
        if (objectName == null) {
            objectName = ObjectName.getInstance(mbean);
            if (objectName.isPattern()) {
                Logger.trace(mbean + "is pattern object name");
                this.ignoreSet.add(mbean);
                return -1.0f;
            }
            this.objectNameMap.put(mbean, objectName);
        }
        try {
            Object value = this.platformMBeanServer.getAttribute(objectName, attribute);
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            Logger.trace(mbean + " " + attribute + " is not a number : " + value);
            this.ignoreSet.add(key);
        }
        catch (InstanceNotFoundException e) {
            int count = this.tryCountMap.get(key);
            if (++count > 30) {
                this.ignoreSet.add(key);
                this.tryCountMap.remove(key);
            } else {
                this.tryCountMap.put(key, count);
            }
        }
        catch (Exception e) {
            Logger.trace(e.getClass().getName() + " : " + mbean + " " + attribute);
            Logger.trace(ThreadUtil.getStackTrace(e));
            this.ignoreSet.add(key);
        }
        return -1.0f;
    }
}

