/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.ApicallExtCV;
import scouter.agent.asm.IASM;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.util.Pair;

public class ApicallASM
implements IASM,
Opcodes {
    private List<HookingSet> target;
    private Map<String, HookingSet> reserved;

    public ApicallASM() {
        this.target = HookingSet.getHookingMethodSet(Configure.getInstance().hook_apicall_patterns);
        this.reserved = new HashMap<String, HookingSet>();
        AsmUtil.add(this.reserved, "sun/net/www/protocol/http/HttpURLConnection", "getInputStream()Ljava/io/InputStream;");
        AsmUtil.add(this.reserved, "sun/net/www/protocol/http/HttpURLConnection", "connect()V");
        AsmUtil.add(this.reserved, "org/apache/commons/httpclient/HttpClient", "executeMethod(Lorg/apache/commons/httpclient/HostConfiguration;Lorg/apache/commons/httpclient/HttpMethod;Lorg/apache/commons/httpclient/HttpState;)I");
        AsmUtil.add(this.reserved, "org/apache/http/impl/client/InternalHttpClient", "doExecute");
        AsmUtil.add(this.reserved, "sun/net/www/http/HttpClient", "parseHTTP");
        AsmUtil.add(this.reserved, "org/apache/http/impl/client/AbstractHttpClient", "execute(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/HttpResponse;");
        AsmUtil.add(this.reserved, "com/sap/mw/jco/JCO$Client", "execute(Ljava/lang/String;Lcom/sap/mw/jco/JCO$ParameterList;Lcom/sap/mw/jco/JCO$ParameterList;Lcom/sap/mw/jco/JCO$ParameterList;Lcom/sap/mw/jco/JCO$ParameterList;Ljava/lang/String;Ljava/lang/String;I)V");
        AsmUtil.add(this.reserved, "io/reactivex/netty/protocol/http/client/HttpClientImpl", "submit");
        AsmUtil.add(this.reserved, "org/springframework/web/client/RestTemplate", "doExecute(Ljava/net/URI;Lorg/springframework/http/HttpMethod;Lorg/springframework/web/client/RequestCallback;Lorg/springframework/web/client/ResponseExtractor;)Ljava/lang/Object;");
        AsmUtil.add(this.reserved, "org/springframework/web/client/AsyncRestTemplate", "doExecute(Ljava/net/URI;Lorg/springframework/http/HttpMethod;Lorg/springframework/web/client/AsyncRequestCallback;Lorg/springframework/web/client/ResponseExtractor;)Lorg/springframework/util/concurrent/ListenableFuture;");
        for (int i = ApiCallTargetRegister.klassMethod.size() - 1; i >= 0; --i) {
            AsmUtil.add(this.reserved, ApiCallTargetRegister.klassMethod.get(i).getLeft(), ApiCallTargetRegister.klassMethod.get(i).getRight());
        }
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_apicall_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new ApicallExtCV(cv, mset, className);
        }
        for (int i = 0; i < this.target.size(); ++i) {
            mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new ApicallExtCV(cv, mset, className);
        }
        return cv;
    }

    public static class ApiCallTargetRegister {
        public static final List<Pair<String, String>> klassMethod = new ArrayList<Pair<String, String>>();

        public static void regist(String klass, String method) {
            klassMethod.add(new Pair<String, String>(klass, method));
        }
    }
}

