/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.pack;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.DateUtil;
import scouter.util.Hexa32;

public class StatusPack
implements Pack {
    public long time;
    public String objType;
    public int objHash;
    public String key;
    public MapValue data = new MapValue();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Status ");
        sb.append(DateUtil.timestamp(this.time));
        sb.append(" objType=").append(this.objType);
        sb.append(" objHash=").append(Hexa32.toString32(this.objHash));
        sb.append(" key=").append(this.key);
        sb.append(" data=").append(this.data);
        return sb.toString();
    }

    @Override
    public byte getPackType() {
        return 61;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        out.writeDecimal(this.time);
        out.writeText(this.objType);
        out.writeDecimal(this.objHash);
        out.writeText(this.key);
        out.writeValue(this.data);
    }

    @Override
    public Pack read(DataInputX in) throws IOException {
        this.time = in.readDecimal();
        this.objType = in.readText();
        this.objHash = (int)in.readDecimal();
        this.key = in.readText();
        this.data = (MapValue)in.readValue();
        return this;
    }

    public ListValue newList(String name) {
        ListValue list = new ListValue();
        this.data.put(name, list);
        return list;
    }

    public MapPack toMapPack() {
        MapPack pack = new MapPack();
        for (String key : this.data.keySet()) {
            pack.put(key, this.data.get(key));
        }
        return pack;
    }
}

