/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace.api;

import java.util.HashMap;
import java.util.Map;
import scouter.agent.trace.HookArgs;
import scouter.agent.trace.TraceContext;
import scouter.agent.trace.api.ForDefault;
import scouter.agent.trace.api.ForHttpClient;
import scouter.agent.trace.api.ForHttpClient40;
import scouter.agent.trace.api.ForHttpClient43;
import scouter.agent.trace.api.ForHttpURLConnection;
import scouter.agent.trace.api.ForJCOClient;
import scouter.agent.trace.api.ForNettyHttpRequest;
import scouter.agent.trace.api.ForRibbonLB;
import scouter.agent.trace.api.ForSpringAsyncRestTemplate;
import scouter.agent.trace.api.ForSpringRestTemplate;
import scouter.agent.trace.api.ForSunHttpClient;
import scouter.lang.step.ApiCallStep;

public class ApiCallTraceHelper {
    static Map<String, IHelper> handlers = new HashMap<String, IHelper>();
    static ForHttpClient43 forHttpClient43 = new ForHttpClient43();
    static ForSpringAsyncRestTemplate forSpringAsyncRestTemplate = new ForSpringAsyncRestTemplate();
    private static IHelper defaultObj;

    static void put(String name, IHelper o) {
        name = name.replace('.', '/');
        handlers.put(name, o);
    }

    public static IHelper get(String name) {
        return handlers.get(name);
    }

    public static ApiCallStep start(TraceContext ctx, HookArgs hookPoint) {
        IHelper plug = handlers.get(hookPoint.class1);
        if (plug == null) {
            return defaultObj.process(ctx, hookPoint);
        }
        return plug.process(ctx, hookPoint);
    }

    public static void end(TraceContext ctx, ApiCallStep step, Object rtn, HookArgs hookPoint) {
        IHelper plug = handlers.get(hookPoint.class1);
        if (plug == null) {
            defaultObj.processEnd(ctx, step, rtn, hookPoint);
        }
        plug.processEnd(ctx, step, rtn, hookPoint);
    }

    public static void setCalleeToCtxInHttpClientResponse(TraceContext ctx, Object _this, Object response) {
        forHttpClient43.processSetCalleeToCtx(ctx, _this, response);
    }

    public static void setCalleeToCtxInSpringClientHttpResponse(TraceContext ctx, Object _this, Object response) {
        forSpringAsyncRestTemplate.processSetCalleeToCtx(ctx, _this, response);
    }

    static {
        ApiCallTraceHelper.put("sun/net/www/protocol/http/HttpURLConnection", new ForHttpURLConnection());
        ApiCallTraceHelper.put("sun/net/www/http/HttpClient", new ForSunHttpClient());
        ApiCallTraceHelper.put("org/apache/commons/httpclient/HttpClient", new ForHttpClient());
        ApiCallTraceHelper.put("org/apache/http/impl/client/InternalHttpClient", new ForHttpClient43());
        ApiCallTraceHelper.put("org/apache/http/impl/client/AbstractHttpClient", new ForHttpClient40());
        ApiCallTraceHelper.put("com/sap/mw/jco/JCO$Client", new ForJCOClient());
        ApiCallTraceHelper.put("com/netflix/ribbon/transport/netty/http/LoadBalancingHttpClient", new ForRibbonLB());
        ApiCallTraceHelper.put("io/reactivex/netty/protocol/http/client/HttpClientImpl", new ForNettyHttpRequest());
        ApiCallTraceHelper.put("org/springframework/web/client/RestTemplate", new ForSpringRestTemplate());
        ApiCallTraceHelper.put("org/springframework/web/client/AsyncRestTemplate", new ForSpringAsyncRestTemplate());
        defaultObj = new ForDefault();
    }

    static interface IHelper {
        public ApiCallStep process(TraceContext var1, HookArgs var2);

        public void processEnd(TraceContext var1, ApiCallStep var2, Object var3, HookArgs var4);
    }
}

