/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import scouter.agent.Logger;
import scouter.agent.asm.SpringReqMapASM;
import scouter.agent.asm.util.AsmUtil;
import scouter.org.objectweb.asm.AnnotationVisitor;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;
import scouter.org.objectweb.asm.commons.LocalVariablesSorter;
import scouter.util.StringUtil;

class SpringReqMapCV
extends ClassVisitor
implements Opcodes {
    public String className;
    public String classRequestMappingUrl;

    public SpringReqMapCV(ClassVisitor cv, String className) {
        super(458752, cv);
        this.className = className;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (av == null) {
            return av;
        }
        if (SpringReqMapASM.springRequestMappingAnnotations.contains(desc)) {
            return new SpringReqMapCVAV(av);
        }
        return av;
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, methodName, desc, signature, exceptions);
        if (mv == null) {
            return mv;
        }
        if (AsmUtil.isSpecial(methodName)) {
            return mv;
        }
        return new SpringReqMapMV(this.className, access, methodName, desc, mv);
    }

    class SpringReqMapMV
    extends LocalVariablesSorter
    implements Opcodes {
        private static final String TRACEMAIN = "scouter/agent/trace/TraceMain";
        private static final String SET_METHOD = "setSpringControllerName";
        private static final String SET_METHOD_SIGNATURE = "(Ljava/lang/String;)V";
        private static final String CONTROLLER_START_METHOD = "startSpringControllerMethod";
        private static final String CONTROLLER_START_METHOD_SIGNATURE = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;[Ljava/lang/Object;)V";
        private String methodRequestMappingUrl;
        private String methodType;
        private boolean isRequestHandler;
        private String className;
        private int access;
        private String methodName;
        private String desc;

        public SpringReqMapMV(String className, int access, String methodName, String desc, MethodVisitor mv) {
            super(458752, access, desc, mv);
            this.isRequestHandler = false;
            this.className = className;
            this.access = access;
            this.methodName = methodName;
            this.desc = desc;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (SpringReqMapASM.springRequestMappingAnnotations.contains(desc)) {
                if (!desc.endsWith("RequestMapping;")) {
                    String pkg = "web/bind/annotation/";
                    String postfix = "Mapping;";
                    int index = desc.indexOf(pkg);
                    if (index > -1) {
                        int startIndex = index + pkg.length();
                        index = desc.lastIndexOf(postfix);
                        if (index > startIndex) {
                            int lastIndex = index;
                            this.methodType = desc.substring(startIndex, lastIndex).toUpperCase();
                        }
                    }
                }
                return new SpringReqMapMVAV(av);
            }
            return av;
        }

        @Override
        public void visitCode() {
            if (this.isRequestHandler) {
                StringBuilder sb = new StringBuilder(60);
                sb.append(StringUtil.trimEmpty(SpringReqMapCV.this.classRequestMappingUrl)).append(StringUtil.trimEmpty(this.methodRequestMappingUrl));
                if (!StringUtil.isEmpty(this.methodType)) {
                    sb.append("<").append(this.methodType).append(">");
                }
                String serviceUrl = sb.toString();
                Logger.println("[Apply Spring F/W REST URL] " + serviceUrl);
                AsmUtil.PUSH(this.mv, serviceUrl);
                this.mv.visitMethodInsn(184, TRACEMAIN, SET_METHOD, SET_METHOD_SIGNATURE, false);
                Type[] types = Type.getArgumentTypes(this.desc);
                boolean isStatic = (this.access & 8) != 0;
                int sidx = isStatic ? 0 : 1;
                int arrVarIdx = this.newLocal(Type.getType("[Ljava/lang/Object;"));
                AsmUtil.PUSH(this.mv, types.length);
                this.mv.visitTypeInsn(189, "java/lang/Object");
                this.mv.visitVarInsn(58, arrVarIdx);
                for (int i = 0; i < types.length; ++i) {
                    Type type = types[i];
                    this.mv.visitVarInsn(25, arrVarIdx);
                    AsmUtil.PUSH(this.mv, i);
                    switch (type.getSort()) {
                        case 1: {
                            this.mv.visitVarInsn(21, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                            break;
                        }
                        case 3: {
                            this.mv.visitVarInsn(21, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                            break;
                        }
                        case 2: {
                            this.mv.visitVarInsn(21, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                            break;
                        }
                        case 4: {
                            this.mv.visitVarInsn(21, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                            break;
                        }
                        case 5: {
                            this.mv.visitVarInsn(21, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                            break;
                        }
                        case 7: {
                            this.mv.visitVarInsn(22, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                            break;
                        }
                        case 6: {
                            this.mv.visitVarInsn(23, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                            break;
                        }
                        case 8: {
                            this.mv.visitVarInsn(24, sidx);
                            this.mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                            break;
                        }
                        default: {
                            this.mv.visitVarInsn(25, sidx);
                        }
                    }
                    this.mv.visitInsn(83);
                    sidx += type.getSize();
                }
                AsmUtil.PUSH(this.mv, this.className);
                AsmUtil.PUSH(this.mv, this.methodName);
                AsmUtil.PUSH(this.mv, this.desc);
                if (isStatic) {
                    AsmUtil.PUSHNULL(this.mv);
                } else {
                    this.mv.visitVarInsn(25, 0);
                }
                this.mv.visitVarInsn(25, arrVarIdx);
                this.mv.visitMethodInsn(184, TRACEMAIN, CONTROLLER_START_METHOD, CONTROLLER_START_METHOD_SIGNATURE, false);
            }
            this.mv.visitCode();
        }

        class SpringReqMapMVAVAV
        extends AnnotationVisitor
        implements Opcodes {
            String paramName;

            public SpringReqMapMVAVAV(AnnotationVisitor av, String paramName) {
                super(458752, av);
                this.paramName = paramName;
            }

            @Override
            public void visit(String name, Object value) {
                super.visit(name, value);
                if (!"value".equals(this.paramName) && !"path".equals(this.paramName)) {
                    return;
                }
                if (value instanceof String) {
                    String sValue = (String)value;
                    SpringReqMapMV.this.methodRequestMappingUrl = sValue;
                    SpringReqMapMV.this.isRequestHandler = true;
                }
            }

            @Override
            public void visitEnum(String name, String desc, String value) {
                super.visitEnum(name, desc, value);
                if (!"method".equals(this.paramName)) {
                    return;
                }
                SpringReqMapMV.this.methodType = value;
                SpringReqMapMV.this.isRequestHandler = true;
            }
        }

        class SpringReqMapMVAV
        extends AnnotationVisitor
        implements Opcodes {
            public SpringReqMapMVAV(AnnotationVisitor av) {
                super(458752, av);
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if (av == null) {
                    return av;
                }
                if ("value".equals(name) || "method".equals(name) || "path".equals(name)) {
                    return new SpringReqMapMVAVAV(av, name);
                }
                return av;
            }
        }
    }

    class SpringReqMapCVAVAV
    extends AnnotationVisitor
    implements Opcodes {
        public SpringReqMapCVAVAV(AnnotationVisitor av) {
            super(458752, av);
        }

        @Override
        public void visit(String name, Object value) {
            super.visit(name, value);
            String v = value.toString();
            if (StringUtil.isNotEmpty(v)) {
                SpringReqMapCV.this.classRequestMappingUrl = v;
            }
        }
    }

    class SpringReqMapCVAV
    extends AnnotationVisitor
    implements Opcodes {
        public SpringReqMapCVAV(AnnotationVisitor av) {
            super(458752, av);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            AnnotationVisitor av = super.visitArray(name);
            if (av == null) {
                return av;
            }
            if ("value".equals(name) || "path".equals(name)) {
                return new SpringReqMapCVAVAV(av);
            }
            return av;
        }
    }
}

