/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang;

import scouter.util.IntKeyMap;
import scouter.util.ObjectUtil;
import scouter.util.StringIntMap;

public class TimeTypeEnum {
    public static final byte REALTIME = 1;
    public static final byte ONE_MIN = 2;
    public static final byte FIVE_MIN = 3;
    public static final byte TEN_MIN = 4;
    public static final byte HOUR = 5;
    public static final byte DAY = 6;
    private static final IntKeyMap<String> lookup = new IntKeyMap();
    private static final StringIntMap lookname = new StringIntMap();

    private static void add(String name, byte code) {
        lookup.put(code, name);
        lookname.put(name, code);
    }

    public static String get(byte code) {
        return lookup.get(code);
    }

    public static byte get(String name) {
        return (byte)lookname.get(name);
    }

    public static String getString(byte code) {
        return ObjectUtil.toString(lookup.get(code));
    }

    public static byte getCode(String name) {
        return TimeTypeEnum.get(name);
    }

    public static byte getCodeBySec(int sec) {
        if (sec < 60) {
            return 1;
        }
        switch (sec) {
            case 60: {
                return 2;
            }
            case 300: {
                return 3;
            }
            case 600: {
                return 4;
            }
            case 3600: {
                return 5;
            }
        }
        return 6;
    }

    public static int getTime(byte timeCode) {
        switch (timeCode) {
            case 1: {
                return 2000;
            }
            case 2: {
                return 60000;
            }
            case 3: {
                return 300000;
            }
            case 5: {
                return 3600000;
            }
            case 6: {
                return 86400000;
            }
        }
        return 0;
    }

    static {
        TimeTypeEnum.add("REALTIME", (byte)1);
        TimeTypeEnum.add("ONE_MIN", (byte)2);
        TimeTypeEnum.add("FIVE_MIN", (byte)3);
        TimeTypeEnum.add("TEN_MIN", (byte)4);
        TimeTypeEnum.add("HOUR", (byte)5);
        TimeTypeEnum.add("DAY", (byte)6);
    }
}

