/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.asm.ILASM;
import scouter.agent.asm.ScouterClassWriter;
import scouter.agent.asm.asyncsupport.LambdaFormASM;
import scouter.agent.asm.util.AsmUtil;
import scouter.org.objectweb.asm.ClassReader;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.ClassWriter;
import scouter.util.StringUtil;

public class LambdaFormTransformer {
    protected static List<ILASM> asms = new ArrayList<ILASM>();
    private static List<String> scanScopePrefix = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer, String lambdaMethodName, String lambdaMethodDesc, String factoryMethodName, String factoryMethodDesc) throws IllegalClassFormatException {
        ClassReader cr;
        ClassDesc classDesc;
        block11: {
            block10: {
                block9: {
                    if (className != null) break block9;
                    byte[] byArray = null;
                    return byArray;
                }
                boolean scoped = false;
                for (int i = 0; i < scanScopePrefix.size(); ++i) {
                    if (className.indexOf(scanScopePrefix.get(i)) != 0) continue;
                    scoped = true;
                    break;
                }
                if (scoped) break block10;
                byte[] i = null;
                return i;
            }
            classDesc = new ClassDesc();
            cr = new ClassReader(classfileBuffer);
            cr.accept(new ClassVisitor(458752){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    classDesc.set(version, access, name, signature, superName, interfaces);
                    super.visit(version, access, name, signature, superName, interfaces);
                }
            }, 0);
            if (!AsmUtil.isInterface(classDesc.access)) break block11;
            byte[] byArray = null;
            return byArray;
        }
        try {
            ClassWriter cw;
            classDesc.classBeingRedefined = classBeingRedefined;
            ClassVisitor cv = cw = this.getClassWriter(classDesc);
            List<ILASM> workAsms = asms;
            for (int i = workAsms.size() - 1; i >= 0; --i) {
                cv = workAsms.get(i).transform(cv, className, classDesc, lambdaMethodName, lambdaMethodDesc, factoryMethodName, factoryMethodDesc);
                if (cv == cw) continue;
                cr = new ClassReader(classfileBuffer);
                cr.accept(cv, 8);
                classfileBuffer = cw.toByteArray();
                cv = cw = this.getClassWriter(classDesc);
            }
            byte[] byArray = classfileBuffer;
            return byArray;
        }
        catch (Throwable t) {
            Logger.println("B101", "LambdaFormTransformer Error", t);
            t.printStackTrace();
        }
        return null;
    }

    private ClassWriter getClassWriter(ClassDesc classDesc) {
        ScouterClassWriter cw;
        switch (classDesc.version) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 196653: {
                cw = new ScouterClassWriter(1);
                break;
            }
            default: {
                cw = new ScouterClassWriter(3);
            }
        }
        return cw;
    }

    static {
        Configure conf = Configure.getInstance();
        if (conf.hook_async_callrunnable_enabled) {
            String[] prefixes = StringUtil.split(conf.hook_async_callrunnable_scan_package_prefixes, ',');
            for (int i = 0; i < prefixes.length; ++i) {
                scanScopePrefix.add(prefixes[i].replace('.', '/'));
            }
        }
        asms.add(new LambdaFormASM());
    }
}

