/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.rabbit;

import java.util.HashMap;
import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.rabbit.RabbitPublisherCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class RabbitPublisherASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();
    private Map<String, HookingSet> reserved = new HashMap<String, HookingSet>();

    public RabbitPublisherASM() {
        AsmUtil.add(this.reserved, "com.rabbitmq.client.impl.ChannelN", "basicPublish(Ljava/lang/String;Ljava/lang/String;ZZLcom/rabbitmq/client/AMQP$BasicProperties;[B)V");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf._hook_rabbit_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new RabbitPublisherCV(cv, mset, className);
        }
        return cv;
    }
}

