/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.netio.data.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.conf.ConfObserver;
import scouter.net.NetCafe;
import scouter.util.CastUtil;
import scouter.util.CompareUtil;
import scouter.util.KeyGen;
import scouter.util.ShellArg;
import scouter.util.ThreadUtil;

public class DataUdpAgent {
    private static DataUdpAgent inst;
    InetAddress server_host;
    int server_port;
    String local_udp_addr;
    int local_udp_port;
    private DatagramSocket datagram;
    private Configure conf = Configure.getInstance();

    private DataUdpAgent() {
        this.setTarget();
        this.openDatagramSocket();
        ConfObserver.add(DataUdpAgent.class.getName(), new Runnable(){

            @Override
            public void run() {
                DataUdpAgent.this.setTarget();
                DataUdpAgent.this.openDatagramSocket();
            }
        });
    }

    private void setTarget() {
        Configure conf = Configure.getInstance();
        String host = conf.net_collector_ip;
        int port = conf.net_collector_udp_port;
        try {
            this.server_host = InetAddress.getByName(host);
            this.server_port = port;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void close(DatagramSocket d) {
        if (d != null) {
            try {
                d.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void openDatagramSocket() {
        try {
            Configure conf = Configure.getInstance();
            String host = conf.net_local_udp_ip;
            int port = conf.net_local_udp_port;
            if (this.datagram == null || !CompareUtil.equals(host, this.local_udp_addr) || this.local_udp_port != port) {
                this.close(this.datagram);
                this.local_udp_addr = host;
                this.local_udp_port = port;
                if (host != null) {
                    this.datagram = new DatagramSocket(port, InetAddress.getByName(host));
                    Logger.println("A118", "Agent UDP local.addr=" + host + " local.port=" + port);
                } else {
                    this.datagram = new DatagramSocket(port);
                    Logger.println("A119", "Agent UDP local.port=" + port);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized DataUdpAgent getInstance() {
        if (inst == null) {
            inst = new DataUdpAgent();
        }
        return inst;
    }

    public boolean write(byte[] p) {
        try {
            if (this.server_host == null) {
                return false;
            }
            if (p.length > this.conf.net_udp_packet_max_bytes) {
                return this.writeMTU(p, this.conf.net_udp_packet_max_bytes);
            }
            DataOutputX out = new DataOutputX();
            out.write(NetCafe.CAFE);
            out.write(p);
            byte[] buff = out.toByteArray();
            DatagramPacket packet = new DatagramPacket(buff, buff.length);
            packet.setAddress(this.server_host);
            packet.setPort(this.server_port);
            this.datagram.send(packet);
            return true;
        }
        catch (IOException e) {
            Logger.println("A120", "UDP", e);
            return false;
        }
    }

    private boolean writeMTU(byte[] data, int packetSize) {
        try {
            if (this.server_host == null) {
                return false;
            }
            long pkid = KeyGen.next();
            int total = data.length / packetSize;
            int remainder = data.length % packetSize;
            if (remainder > 0) {
                ++total;
            }
            int num = 0;
            for (num = 0; num < data.length / packetSize; ++num) {
                this.writeMTU(pkid, total, num, packetSize, DataInputX.get(data, num * packetSize, packetSize));
            }
            if (remainder > 0) {
                this.writeMTU(pkid, total, num, remainder, DataInputX.get(data, data.length - remainder, remainder));
            }
            return true;
        }
        catch (IOException e) {
            Logger.println("A121", "UDP", e);
            return false;
        }
    }

    private void writeMTU(long pkid, int total, int num, int packetSize, byte[] data) throws IOException {
        DataOutputX out = new DataOutputX();
        out.write(NetCafe.CAFE_MTU);
        out.writeInt(this.conf.getObjHash());
        out.writeLong(pkid);
        out.writeShort(total);
        out.writeShort(num);
        out.writeBlob(data);
        byte[] buff = out.toByteArray();
        DatagramPacket packet = new DatagramPacket(buff, buff.length);
        packet.setAddress(this.server_host);
        packet.setPort(this.server_port);
        this.datagram.send(packet);
    }

    public void close() {
        if (this.datagram != null) {
            this.datagram.close();
        }
        this.datagram = null;
    }

    public boolean write(List<byte[]> p) {
        try {
            if (this.server_host == null) {
                return false;
            }
            DataOutputX buffer = new DataOutputX();
            int bufferCount = 0;
            for (int i = 0; i < p.size(); ++i) {
                byte[] b = p.get(i);
                if (b.length > this.conf.net_udp_packet_max_bytes) {
                    this.writeMTU(b, this.conf.net_udp_packet_max_bytes);
                    continue;
                }
                if (b.length + buffer.getWriteSize() > this.conf.net_udp_packet_max_bytes) {
                    this.sendList(bufferCount, buffer.toByteArray());
                    buffer = new DataOutputX();
                    bufferCount = 1;
                    buffer.write(b);
                    continue;
                }
                ++bufferCount;
                buffer.write(b);
            }
            if (buffer.getWriteSize() > 0) {
                this.sendList(bufferCount, buffer.toByteArray());
            }
            return true;
        }
        catch (IOException e) {
            Logger.println("A123", "UDP", e);
            return false;
        }
    }

    private void sendList(int bufferCount, byte[] buffer) throws IOException {
        DataOutputX outter = new DataOutputX();
        outter.write(NetCafe.CAFE_N);
        outter.writeShort(bufferCount);
        outter.write(buffer);
        byte[] buff = outter.toByteArray();
        DatagramPacket packet = new DatagramPacket(buff, buff.length);
        packet.setAddress(this.server_host);
        packet.setPort(this.server_port);
        this.datagram.send(packet);
    }

    public boolean debugWrite(String ip, int port, int length) {
        try {
            DataOutputX out = new DataOutputX();
            out.write("TEST".getBytes());
            if (length > 4) {
                out.write(new byte[length - 4]);
            }
            byte[] buff = out.toByteArray();
            DatagramPacket packet = new DatagramPacket(buff, buff.length);
            packet.setAddress(InetAddress.getByName(ip));
            packet.setPort(port);
            this.datagram.send(packet);
            Logger.println("A124", "Sent " + length + " bytes to " + ip + ":" + port);
            return true;
        }
        catch (IOException e) {
            Logger.println("A125", "UDP " + e.toString());
            return false;
        }
    }

    public static void main(String[] args) {
        ShellArg param = new ShellArg(args);
        String host = param.get("-h");
        int port = CastUtil.cint(param.get("-p"));
        int length = CastUtil.cint(param.get("-l"));
        if (length == 0) {
            System.out.println("Incorrect args\nex) -h 127.0.0.1 -p 6100 -l 32767");
            return;
        }
        for (int i = 0; i < 100; ++i) {
            DataUdpAgent.getInstance().debugWrite(host, port, length);
            ThreadUtil.sleep(2000L);
        }
    }
}

