/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.counter.meter;

import java.util.Enumeration;
import scouter.agent.Configure;
import scouter.agent.Logger;
import scouter.agent.counter.meter.MeterResource;
import scouter.util.LongLongLinkedMap;

public class MeterUsers {
    private static final int MAX_USERS = 70000;
    protected static LongLongLinkedMap users = new LongLongLinkedMap().setMax(70000);
    protected static MeterResource firstVisitors = new MeterResource();

    public static void add(long userid) {
        if (userid == 0L) {
            firstVisitors.add(1.0);
        } else {
            users.putLast(userid, System.currentTimeMillis());
        }
    }

    public static synchronized int getUsers() {
        long max_think_time = Configure.getInstance().counter_recentuser_valid_ms;
        int v = 0;
        long now = System.currentTimeMillis();
        try {
            Enumeration<LongLongLinkedMap.LongLongLinkedEntry> en = users.entries();
            while (en.hasMoreElements()) {
                LongLongLinkedMap.LongLongLinkedEntry e = en.nextElement();
                if (now - e.getValue() > max_think_time) {
                    users.remove(e.getKey());
                    continue;
                }
                ++v;
            }
        }
        catch (Throwable t) {
            Logger.println("A114", "METER-USERS" + t.toString());
        }
        return v;
    }

    public static synchronized int getNewUsers() {
        return (int)firstVisitors.getSum(300);
    }

    public static void main(String[] args) throws InterruptedException {
        for (int i = 1; i <= 100; ++i) {
            if (i == 50) {
                Thread.sleep(1000L);
            }
            MeterUsers.add(i);
        }
        Thread.sleep(1000L);
        System.out.println(MeterUsers.getUsers());
    }
}

