/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.trace;

import java.util.Enumeration;
import scouter.agent.Configure;
import scouter.agent.trace.TraceContext;
import scouter.util.KeyGen;
import scouter.util.LongKeyMap;

public class TraceContextManager {
    private static Configure conf = Configure.getInstance();
    private static LongKeyMap<TraceContext> entry = new LongKeyMap();
    private static ThreadLocal<TraceContext> local = new ThreadLocal();
    private static LongKeyMap<TraceContext> deferredEntry = new LongKeyMap();
    private static ThreadLocal<Integer> forceDiscard = new ThreadLocal();

    public static int size() {
        return entry.size();
    }

    public static int[] getActiveCount() {
        int[] act = new int[3];
        try {
            long now = System.currentTimeMillis();
            Enumeration<TraceContext> en = entry.values();
            while (en.hasMoreElements()) {
                TraceContext ctx = en.nextElement();
                long tm = now - ctx.startTime;
                if (tm < TraceContextManager.conf.trace_activeserivce_yellow_time) {
                    act[0] = act[0] + 1;
                    continue;
                }
                if (tm < TraceContextManager.conf.trace_activeservice_red_time) {
                    act[1] = act[1] + 1;
                    continue;
                }
                act[2] = act[2] + 1;
            }
            Enumeration<TraceContext> enDeferred = deferredEntry.values();
            while (enDeferred.hasMoreElements()) {
                TraceContext ctx = enDeferred.nextElement();
                long tm = now - ctx.startTime;
                if (tm < TraceContextManager.conf.trace_activeserivce_yellow_time) {
                    act[0] = act[0] + 1;
                    continue;
                }
                if (tm < TraceContextManager.conf.trace_activeservice_red_time) {
                    act[1] = act[1] + 1;
                    continue;
                }
                act[2] = act[2] + 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return act;
    }

    public static Enumeration<TraceContext> getContextEnumeration() {
        return entry.values();
    }

    public static Enumeration<TraceContext> getDeferredContextEnumeration() {
        return deferredEntry.values();
    }

    public static TraceContext getContext(long key) {
        return entry.get(key);
    }

    public static TraceContext getDeferredContext(long key) {
        return deferredEntry.get(key);
    }

    public static TraceContext getContext() {
        return local.get();
    }

    public static void clearForceDiscard() {
        if (!TraceContextManager.conf._xlog_hard_sampling_enabled) {
            return;
        }
        Integer num = forceDiscard.get();
        if (num == null) {
            forceDiscard.set(-1);
        } else if (num == 1) {
            forceDiscard.set(-1);
        } else if (num == 2) {
            forceDiscard.set(-2);
        }
    }

    public static boolean isForceDiscarded() {
        if (!TraceContextManager.conf._xlog_hard_sampling_enabled) {
            return false;
        }
        boolean discard = false;
        Integer num = forceDiscard.get();
        if (num == null) {
            return false;
        }
        if (num == 2 || num == -2) {
            discard = true;
        }
        return discard;
    }

    public static boolean startForceDiscard() {
        if (!TraceContextManager.conf._xlog_hard_sampling_enabled) {
            return false;
        }
        boolean discard = false;
        Integer num = forceDiscard.get();
        if (num == null || num == -1 || num == -2) {
            if (Math.abs(KeyGen.next() % 100L) >= (long)TraceContextManager.conf._xlog_hard_sampling_rate_pct) {
                discard = true;
                forceDiscard.set(2);
            } else {
                forceDiscard.set(1);
            }
        } else if (num == 2) {
            discard = true;
        }
        return discard;
    }

    public static long start(Thread thread, TraceContext o) {
        long key = thread.getId();
        local.set(o);
        entry.put(key, o);
        return key;
    }

    public static void end(long key) {
        local.set(null);
        entry.remove(key);
        TraceContextManager.clearForceDiscard();
    }

    public static void toDeferred(TraceContext o) {
        deferredEntry.put(o.txid, o);
    }

    public static void completeDeferred(TraceContext o) {
        deferredEntry.remove(o.txid);
    }
}

