/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.db;

import com.google.common.base.Joiner;
import com.gugusong.sqlmapper.common.beans.BeanWrapper;
import com.gugusong.sqlmapper.common.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class ConditionFragment {
    public static final int CONDITION_FRAGMENT_TOKEN = 0;
    public static final int CONDITION_FRAGMENT_EXP = 1;
    public static final int CONDITION_FRAGMENT_CONDITION = 2;
    public static final int CONDITION_FRAGMENT_ORDER = 3;
    private int type = 0;
    private String expression;
    private String property;
    private Object value;
    private boolean logicShip = false;
    private ConditionFragment nextFragment;
    private ConditionFragment beforeFragment;

    public ConditionFragment(String token) {
        this(0, token, null, null);
    }

    public ConditionFragment(int type, String expression, String property, Object value) {
        this.type = type;
        this.expression = expression;
        this.property = property;
        this.value = value;
        if ("and".equalsIgnoreCase(expression) || "or".equalsIgnoreCase(expression) || "where".equalsIgnoreCase(expression) || "(".equalsIgnoreCase(expression) || ")".equalsIgnoreCase(expression)) {
            this.logicShip = true;
        }
    }

    public ConditionFragment createNextToken(String token) {
        if (("and".equals(token) || "or".equals(token)) && this.logicShip) {
            return this;
        }
        ConditionFragment currentNext = this.nextFragment;
        this.nextFragment = new ConditionFragment(0, token, null, null);
        this.nextFragment.nextFragment = currentNext;
        this.nextFragment.beforeFragment = this;
        return this.nextFragment;
    }

    public ConditionFragment createNextExp(String token, String property, Object value) {
        ConditionFragment currentNext = this.nextFragment;
        this.nextFragment = new ConditionFragment(1, token, property, value);
        this.nextFragment.nextFragment = currentNext;
        this.nextFragment.beforeFragment = this;
        return this.nextFragment;
    }

    public ConditionFragment createNextCondition(String expression, Object ... value) {
        ConditionFragment currentNext = this.nextFragment;
        this.nextFragment = new ConditionFragment(2, expression, null, Arrays.asList(value));
        this.nextFragment.nextFragment = currentNext;
        this.nextFragment.beforeFragment = this;
        return this.nextFragment;
    }

    public ConditionFragment removeCondition() {
        if ("and".equals(this.expression) || "or".equals(this.expression)) {
            ConditionFragment current = this.beforeFragment;
            current.setNextFragment(this.nextFragment);
            this.beforeFragment = null;
            this.nextFragment = null;
            return current;
        }
        return this;
    }

    public ConditionFragment createNextOrder(String expression, String property) {
        ConditionFragment currentNext = this.nextFragment;
        this.nextFragment = new ConditionFragment(3, expression, property, null);
        this.nextFragment.nextFragment = currentNext;
        return this.nextFragment;
    }

    public String toSql(BeanWrapper entityWrapper) {
        StringBuilder sb = new StringBuilder();
        if (0 == this.type) {
            sb.append(" ");
            sb.append(this.expression);
            sb.append(" ");
        } else if (1 == this.type) {
            @NonNull String columnName = entityWrapper.getColumnNameByPropertyName(this.property);
            sb.append(" ");
            sb.append(columnName);
            sb.append(" ");
            if ("in".equalsIgnoreCase(this.expression)) {
                sb.append(this.expression);
                sb.append(" (");
                List inValues = (List)this.value;
                sb.append(Joiner.on((String)",").join(inValues.stream().map(c -> "?").iterator()));
                sb.append(") ");
            } else {
                sb.append(this.expression);
                sb.append(" ");
                sb.append("?");
            }
        } else if (2 == this.type) {
            sb.append(" ");
            sb.append(TextUtil.replaceTemplateParams(this.expression, paramName -> {
                @NonNull String columnName = entityWrapper.getColumnNameByPropertyName((String)paramName);
                return columnName;
            }));
            sb.append(" ");
        } else if (3 == this.type) {
            @NonNull String columnName = entityWrapper.getColumnNameByPropertyName(this.property);
            sb.append(" ");
            sb.append(columnName);
            sb.append(" ");
            sb.append(this.expression);
        }
        return sb.toString();
    }

    public int getType() {
        return this.type;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isLogicShip() {
        return this.logicShip;
    }

    public ConditionFragment getNextFragment() {
        return this.nextFragment;
    }

    public ConditionFragment getBeforeFragment() {
        return this.beforeFragment;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setLogicShip(boolean logicShip) {
        this.logicShip = logicShip;
    }

    public void setNextFragment(ConditionFragment nextFragment) {
        this.nextFragment = nextFragment;
    }

    public void setBeforeFragment(ConditionFragment beforeFragment) {
        this.beforeFragment = beforeFragment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionFragment)) {
            return false;
        }
        ConditionFragment other = (ConditionFragment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.isLogicShip() != other.isLogicShip()) {
            return false;
        }
        ConditionFragment this$nextFragment = this.getNextFragment();
        ConditionFragment other$nextFragment = other.getNextFragment();
        if (this$nextFragment == null ? other$nextFragment != null : !((Object)this$nextFragment).equals(other$nextFragment)) {
            return false;
        }
        ConditionFragment this$beforeFragment = this.getBeforeFragment();
        ConditionFragment other$beforeFragment = other.getBeforeFragment();
        return !(this$beforeFragment == null ? other$beforeFragment != null : !((Object)this$beforeFragment).equals(other$beforeFragment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionFragment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + (this.isLogicShip() ? 79 : 97);
        ConditionFragment $nextFragment = this.getNextFragment();
        result = result * 59 + ($nextFragment == null ? 43 : ((Object)$nextFragment).hashCode());
        ConditionFragment $beforeFragment = this.getBeforeFragment();
        result = result * 59 + ($beforeFragment == null ? 43 : ((Object)$beforeFragment).hashCode());
        return result;
    }

    public String toString() {
        return "ConditionFragment(type=" + this.getType() + ", expression=" + this.getExpression() + ", property=" + this.getProperty() + ", value=" + this.getValue() + ", logicShip=" + this.isLogicShip() + ", nextFragment=" + this.getNextFragment() + ", beforeFragment=" + this.getBeforeFragment() + ")";
    }
}

