/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.common.util;

import java.util.function.Function;
import lombok.NonNull;

public class TextUtil {
    private static final byte Z_CODE = 90;
    private static final byte A_CODE = 64;
    private static final byte CODE_DIFF = 32;
    private static final char __CODE = '_';
    private static final char TEMP_LEFT_KEY = '{';
    private static final char TEMP_RIGHT_KEY = '}';

    public static String humpToJdbcHump(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        char[] nameChars = name.toCharArray();
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < nameChars.length; ++i) {
            if (nameChars[i] <= 'Z' && nameChars[i] >= '@') {
                if (i != 0) {
                    newName.append('_');
                }
                newName.append((char)(nameChars[i] + 32));
                continue;
            }
            newName.append(nameChars[i]);
        }
        return newName.toString();
    }

    public static String jdbcHumpToHump(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        char[] nameChars = name.toCharArray();
        StringBuilder newName = new StringBuilder();
        boolean hasUpperCase = false;
        for (int i = 0; i < nameChars.length; ++i) {
            if (nameChars[i] == '_') {
                hasUpperCase = true;
                continue;
            }
            if (hasUpperCase) {
                newName.append((char)(nameChars[i] - 32));
                hasUpperCase = false;
                continue;
            }
            if (nameChars[i] >= 'A' && nameChars[i] <= 'Z') {
                newName.append((char)(nameChars[i] + 32));
                continue;
            }
            newName.append(nameChars[i]);
        }
        return newName.toString();
    }

    public static String replaceTemplateParams(@NonNull String template, Function<String, String> conver) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        StringBuilder newTemplate = new StringBuilder();
        StringBuilder paramName = new StringBuilder();
        char[] tempChars = template.toCharArray();
        block0: for (int i = 0; i < tempChars.length; ++i) {
            if ('{' == tempChars[i]) {
                ++i;
                while (i < tempChars.length) {
                    if ('}' == tempChars[i]) {
                        newTemplate.append(conver.apply(paramName.toString()));
                        paramName = new StringBuilder();
                        continue block0;
                    }
                    paramName.append(tempChars[i]);
                    ++i;
                }
                continue;
            }
            newTemplate.append(tempChars[i]);
        }
        return newTemplate.toString();
    }
}

