/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.common.beans;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.gugusong.sqlmapper.annotation.Column;
import com.gugusong.sqlmapper.annotation.Entity;
import com.gugusong.sqlmapper.annotation.Id;
import com.gugusong.sqlmapper.annotation.Transient;
import com.gugusong.sqlmapper.annotation.Version;
import com.gugusong.sqlmapper.annotation.vo.FunctionMapping;
import com.gugusong.sqlmapper.annotation.vo.GroupBy;
import com.gugusong.sqlmapper.annotation.vo.Join;
import com.gugusong.sqlmapper.annotation.vo.ManyToOne;
import com.gugusong.sqlmapper.annotation.vo.OneToMany;
import com.gugusong.sqlmapper.annotation.vo.PropertyMapping;
import com.gugusong.sqlmapper.annotation.vo.VOBean;
import com.gugusong.sqlmapper.common.beans.BeanColumn;
import com.gugusong.sqlmapper.common.beans.BeanJoin;
import com.gugusong.sqlmapper.common.constants.ErrorCodeConstant;
import com.gugusong.sqlmapper.common.exception.SqlException;
import com.gugusong.sqlmapper.common.exception.StructureException;
import com.gugusong.sqlmapper.common.util.TextUtil;
import com.gugusong.sqlmapper.config.GlobalConfig;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class BeanWrapper {
    public static final String BEAN_TYPE_PO = "po";
    public static final String BEAN_TYPE_VO = "vo";
    public static final String BEAN_TYPE_SIMPLE = "simple";
    private static final Map<Class<?>, BeanWrapper> cacheMap = new ConcurrentHashMap();
    private Class<?> poClazz;
    private BeanColumn idColumn;
    private List<BeanColumn> columns;
    private Map<String, BeanColumn> columnsTree = new TreeMap<String, BeanColumn>();
    private String tableName;
    private String tableAliasName;
    private String beanType;
    private Map<String, BeanJoin> joinBeans = new LinkedHashMap<String, BeanJoin>();
    private BeanWrapper mainWrapper;
    private String[] groupBys;
    private boolean pageSubSql = false;
    private BeanWrapper voWrapper;
    private List<BeanColumn> funcColumns;
    private boolean version = false;
    private BeanColumn versionColumn = null;
    private Map<String, String> sqlCache = new TreeMap<String, String>();
    private GlobalConfig config;

    private BeanWrapper(Class<?> beanClazz, GlobalConfig config) {
        this(beanClazz, config, null, null, null, null);
    }

    private BeanWrapper(Class<?> beanClazz, GlobalConfig config, Map<String, BeanJoin> joinBeans, String tableAliasName, BeanWrapper mainWrapper, BeanWrapper voWrapper) {
        this.poClazz = beanClazz;
        this.config = config;
        this.tableAliasName = tableAliasName;
        this.mainWrapper = mainWrapper;
        this.voWrapper = voWrapper;
        if (joinBeans != null) {
            this.joinBeans = joinBeans;
        }
        Entity entity = beanClazz.getAnnotation(Entity.class);
        VOBean voBean = beanClazz.getAnnotation(VOBean.class);
        if (entity != null) {
            this.beanType = BEAN_TYPE_PO;
            this.poInstancee(beanClazz, config);
        } else if (voBean != null) {
            this.beanType = BEAN_TYPE_VO;
            this.tableAliasName = voBean.entityAlias();
            this.voInstancee(beanClazz, config);
        } else {
            this.beanType = BEAN_TYPE_SIMPLE;
            this.simpleBeanInstance(beanClazz, config);
        }
    }

    private void simpleBeanInstance(Class<?> voClazz, GlobalConfig config) {
        Field[] physicalFields = voClazz.getDeclaredFields();
        ArrayList<BeanColumn> columnList = new ArrayList<BeanColumn>(physicalFields.length);
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(voClazz, Object.class);
        }
        catch (IntrospectionException e) {
            throw new StructureException(e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (Field physicalField : physicalFields) {
            BeanColumn beanColumn;
            if (physicalField.isAnnotationPresent(Transient.class) || Modifier.isStatic(physicalField.getModifiers()) || Modifier.isFinal(physicalField.getModifiers())) continue;
            PropertyDescriptor propertyDesc = this.getDescriptorByName(propertyDescriptors, physicalField.getName());
            if (propertyDesc == null) {
                throw new StructureException(ErrorCodeConstant.NOT_BEAN);
            }
            if (physicalField.isAnnotationPresent(ManyToOne.class)) {
                ManyToOne manyToOne = physicalField.getAnnotation(ManyToOne.class);
                @NonNull Class<?> oneClazz = manyToOne.targetClass();
                BeanColumn beanColumn2 = new BeanColumn(null, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), null, null, BeanWrapper.instrance(oneClazz, config, this.joinBeans, this.tableAliasName, this.mainWrapper, this.voWrapper), null);
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn2);
                this.columnsTree.put(beanColumn2.getFieldName(), beanColumn2);
                columnList.add(beanColumn2);
                continue;
            }
            if (physicalField.isAnnotationPresent(OneToMany.class)) {
                OneToMany oneToMany = physicalField.getAnnotation(OneToMany.class);
                @NonNull Class<?> manyClazz = oneToMany.targetClass();
                BeanWrapper oneToManyWrapper = BeanWrapper.instrance(manyClazz, config, this.joinBeans, this.tableAliasName, this.mainWrapper, this.voWrapper);
                HashSet<String> groupBy = new HashSet<String>(oneToManyWrapper.columns.size());
                for (BeanColumn oneToManyColum : oneToManyWrapper.columns) {
                    BeanJoin joinBean = this.joinBeans.get(oneToManyColum.getTableAlias());
                    if (joinBean == null || joinBean.getJoinBeanWrapper().getIdColumn() == null) continue;
                    groupBy.add(oneToManyColum.getTableAlias() + "_" + joinBean.getJoinBeanWrapper().getIdColumn().getName());
                    if (this.voWrapper == null) continue;
                    this.voWrapper.setPageSubSql(true);
                }
                BeanColumn beanColumn3 = new BeanColumn(null, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), null, null, oneToManyWrapper, groupBy.toArray(new String[0]));
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn3);
                this.columnsTree.put(beanColumn3.getFieldName(), beanColumn3);
                columnList.add(beanColumn3);
                continue;
            }
            if (physicalField.isAnnotationPresent(PropertyMapping.class)) {
                PropertyMapping propertyMapping = physicalField.getAnnotation(PropertyMapping.class);
                @NonNull String originalName = propertyMapping.originalName();
                String[] nameSplit = originalName.split("\\.");
                beanColumn = null;
                if (nameSplit.length == 1) {
                    throw new RuntimeException("\u57fa\u7840bean\u7c7b\u4e2d\u5c5e\u6027\u5fc5\u987b\u6307\u5b9a\u8868\u522b\u540d!");
                }
                BeanColumn byPropertyName = null;
                if (nameSplit[0].equals(this.tableAliasName)) {
                    byPropertyName = this.mainWrapper.getByPropertyName(nameSplit[1]);
                } else {
                    BeanJoin beanJoin = this.joinBeans.get(nameSplit[0]);
                    byPropertyName = beanJoin.getJoinBeanWrapper().getByPropertyName(nameSplit[1]);
                }
                beanColumn = new BeanColumn(byPropertyName.getName(), physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), nameSplit[0], nameSplit[0] + "_" + byPropertyName.getAliasName(), null, null);
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn);
                this.columnsTree.put(beanColumn.getFieldName(), beanColumn);
                columnList.add(beanColumn);
                continue;
            }
            if (physicalField.isAnnotationPresent(FunctionMapping.class)) {
                FunctionMapping functionMapping = physicalField.getAnnotation(FunctionMapping.class);
                @NonNull String funcValue = functionMapping.function();
                funcValue = TextUtil.replaceTemplateParams(funcValue, paramName -> {
                    @NonNull String columnName = this.voWrapper.getColumnNameByPropertyName((String)paramName);
                    return columnName;
                });
                String columnName = config.getImplicitNamingStrategy().getColumnName(physicalField.getName());
                beanColumn = new BeanColumn(columnName, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), this.voWrapper.tableAliasName, this.voWrapper.tableAliasName + "_" + columnName, null, null);
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn);
                beanColumn.setFunc(true);
                beanColumn.setFunction(funcValue);
                this.columnsTree.put(beanColumn.getFieldName(), beanColumn);
                columnList.add(beanColumn);
                this.voWrapper.getFuncColumns().add(beanColumn);
                continue;
            }
            throw new RuntimeException("\u57fa\u7840bean\u7c7b\u4e2d\u5c5e\u6027\u5fc5\u987b\u6307\u5b9a\u8868\u522b\u540d!");
        }
        columnList.sort(new Comparator<BeanColumn>(){

            @Override
            public int compare(BeanColumn o1, BeanColumn o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        this.columns = new ArrayList<BeanColumn>(columnList.size());
        this.columns.addAll(columnList);
    }

    private void voInstancee(Class<?> voClazz, GlobalConfig config) {
        GroupBy groupBy;
        VOBean voBean = voClazz.getAnnotation(VOBean.class);
        this.funcColumns = new ArrayList<BeanColumn>();
        @NonNull Class<?> mainPoClazz = voBean.mainPo();
        if (!BeanWrapper.isPo(mainPoClazz)) {
            throw new RuntimeException("\u6307\u5b9a\u4e3bPo\u7c7b\u4e0d\u5b58\u5728!");
        }
        this.mainWrapper = BeanWrapper.instrance(mainPoClazz, config);
        this.tableName = this.mainWrapper.getTableName();
        this.tableAliasName = voBean.entityAlias();
        Join[] joins = (Join[])voClazz.getAnnotationsByType(Join.class);
        if (joins != null && joins.length > 0) {
            for (Join join : joins) {
                this.joinBeans.put(join.entityAlias(), new BeanJoin(join.joinType(), join.joinConditions(), BeanWrapper.instrance(join.po(), config), join.entityAlias()));
            }
        }
        if ((groupBy = voClazz.getAnnotation(GroupBy.class)) != null) {
            this.groupBys = groupBy.properties();
        }
        Field[] physicalFields = voClazz.getDeclaredFields();
        ArrayList<BeanColumn> columnList = new ArrayList<BeanColumn>(physicalFields.length);
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(voClazz, Object.class);
        }
        catch (IntrospectionException e) {
            throw new StructureException(e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (Field physicalField : physicalFields) {
            BeanColumn beanColumn;
            if (physicalField.isAnnotationPresent(Transient.class) || Modifier.isStatic(physicalField.getModifiers()) || Modifier.isFinal(physicalField.getModifiers())) continue;
            PropertyDescriptor propertyDesc = this.getDescriptorByName(propertyDescriptors, physicalField.getName());
            if (propertyDesc == null) {
                throw new StructureException(ErrorCodeConstant.NOT_BEAN);
            }
            if (physicalField.isAnnotationPresent(ManyToOne.class)) {
                ManyToOne manyToOne = physicalField.getAnnotation(ManyToOne.class);
                @NonNull Class<?> oneClazz = manyToOne.targetClass();
                BeanColumn beanColumn2 = new BeanColumn(null, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), null, null, BeanWrapper.instrance(oneClazz, config, this.joinBeans, this.tableAliasName, this.mainWrapper, this), null);
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn2);
                this.columnsTree.put(beanColumn2.getFieldName(), beanColumn2);
                columnList.add(beanColumn2);
                continue;
            }
            if (physicalField.isAnnotationPresent(OneToMany.class)) {
                OneToMany oneToMany = physicalField.getAnnotation(OneToMany.class);
                @NonNull Class<?> manyClazz = oneToMany.targetClass();
                BeanWrapper oneToManyWrapper = BeanWrapper.instrance(manyClazz, config, this.joinBeans, this.tableAliasName, this.mainWrapper, this);
                HashSet<String> groupByCount = new HashSet<String>(oneToManyWrapper.columns.size());
                for (BeanColumn oneToManyColum : oneToManyWrapper.columns) {
                    BeanJoin joinBean;
                    if (oneToManyColum.getTableAlias() == null || (joinBean = this.joinBeans.get(oneToManyColum.getTableAlias())) == null || joinBean.getJoinBeanWrapper().getIdColumn() == null) continue;
                    groupByCount.add(oneToManyColum.getTableAlias() + "_" + joinBean.getJoinBeanWrapper().getIdColumn().getName());
                    this.setPageSubSql(true);
                }
                BeanColumn beanColumn3 = new BeanColumn(null, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), null, null, oneToManyWrapper, groupByCount.toArray(new String[0]));
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn3);
                this.columnsTree.put(beanColumn3.getFieldName(), beanColumn3);
                columnList.add(beanColumn3);
                continue;
            }
            if (physicalField.isAnnotationPresent(PropertyMapping.class)) {
                PropertyMapping propertyMapping = physicalField.getAnnotation(PropertyMapping.class);
                @NonNull String originalName = propertyMapping.originalName();
                String[] nameSplit = originalName.split("\\.");
                beanColumn = null;
                if (nameSplit.length == 1 || nameSplit[0].equals(this.tableAliasName)) {
                    BeanColumn byPropertyName = this.mainWrapper.getByPropertyName(nameSplit[nameSplit.length - 1]);
                    beanColumn = new BeanColumn(byPropertyName.getName(), physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), this.tableAliasName, this.tableAliasName + "_" + byPropertyName.getAliasName(), null, null);
                } else {
                    BeanJoin beanJoin = this.joinBeans.get(nameSplit[0]);
                    BeanColumn byPropertyName = beanJoin.getJoinBeanWrapper().getByPropertyName(nameSplit[1]);
                    beanColumn = new BeanColumn(byPropertyName.getName(), physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), nameSplit[0], nameSplit[0] + "_" + byPropertyName.getAliasName(), null, null);
                }
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn);
                this.columnsTree.put(beanColumn.getFieldName(), beanColumn);
                columnList.add(beanColumn);
                continue;
            }
            if (physicalField.isAnnotationPresent(FunctionMapping.class)) {
                FunctionMapping functionMapping = physicalField.getAnnotation(FunctionMapping.class);
                @NonNull String funcValue = functionMapping.function();
                funcValue = TextUtil.replaceTemplateParams(funcValue, paramName -> {
                    @NonNull String columnName = this.getColumnNameByPropertyName((String)paramName);
                    return columnName;
                });
                String columnName = config.getImplicitNamingStrategy().getColumnName(physicalField.getName());
                beanColumn = new BeanColumn(columnName, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), this.tableAliasName, this.tableAliasName + "_" + columnName, null, null);
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn);
                beanColumn.setFunc(true);
                beanColumn.setFunction(funcValue);
                this.columnsTree.put(beanColumn.getFieldName(), beanColumn);
                columnList.add(beanColumn);
                this.funcColumns.add(beanColumn);
                continue;
            }
            BeanColumn byPropertyName = this.mainWrapper.getByPropertyName(physicalField.getName());
            BeanColumn beanColumn4 = new BeanColumn(byPropertyName.getName(), physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), this.tableAliasName, this.tableAliasName + "_" + byPropertyName.getAliasName(), null, null);
            config.getColumnTypeMapping().convertDbTypeByField(beanColumn4);
            this.columnsTree.put(beanColumn4.getFieldName(), beanColumn4);
            columnList.add(beanColumn4);
        }
        columnList.sort(new Comparator<BeanColumn>(){

            @Override
            public int compare(BeanColumn o1, BeanColumn o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        this.columns = new ArrayList<BeanColumn>(columnList.size());
        this.columns.addAll(columnList);
    }

    private void poInstancee(Class<?> poClazz, GlobalConfig config) {
        Field[] physicalFields = poClazz.getDeclaredFields();
        ArrayList<BeanColumn> columnList = new ArrayList<BeanColumn>(physicalFields.length);
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(poClazz, Object.class);
        }
        catch (IntrospectionException e) {
            throw new StructureException(e);
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (Field physicalField : physicalFields) {
            BeanColumn beanColumn;
            if (physicalField.isAnnotationPresent(Transient.class) || Modifier.isStatic(physicalField.getModifiers()) || Modifier.isFinal(physicalField.getModifiers())) continue;
            PropertyDescriptor propertyDesc = this.getDescriptorByName(propertyDescriptors, physicalField.getName());
            if (propertyDesc == null) {
                throw new StructureException(ErrorCodeConstant.NOT_BEAN);
            }
            if (physicalField.isAnnotationPresent(Id.class)) {
                Id id = physicalField.getAnnotation(Id.class);
                beanColumn = new BeanColumn(Strings.isNullOrEmpty((String)id.name()) ? config.getImplicitNamingStrategy().getColumnName(physicalField.getName()) : id.name(), null, 11, true, id.strategy(), physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), 0);
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn);
                this.columnsTree.put(beanColumn.getFieldName(), beanColumn);
                columnList.add(beanColumn);
                this.idColumn = beanColumn;
                continue;
            }
            if (physicalField.isAnnotationPresent(Column.class)) {
                Column column = physicalField.getAnnotation(Column.class);
                beanColumn = new BeanColumn(Strings.isNullOrEmpty((String)column.name()) ? config.getImplicitNamingStrategy().getColumnName(physicalField.getName()) : column.name(), Strings.isNullOrEmpty((String)column.dateType()) ? null : column.dateType(), column.length() == 0 ? null : Integer.valueOf(column.length()), false, null, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), column.sort());
                config.getColumnTypeMapping().convertDbTypeByField(beanColumn);
                if (physicalField.isAnnotationPresent(Version.class)) {
                    Version versionAnno = physicalField.getAnnotation(Version.class);
                    beanColumn.setVersion(true);
                    beanColumn.setVersionStrategy(versionAnno.strategy());
                    if (this.version) {
                        throw new SqlException("\u5f53\u4e2aPO\u7c7b\u4e2d\u4e50\u89c2\u9501\u5b57\u6bb5\u4e0d\u652f\u6301\u591a\u4e2a!");
                    }
                    this.version = true;
                    this.versionColumn = beanColumn;
                }
                this.columnsTree.put(beanColumn.getFieldName(), beanColumn);
                columnList.add(beanColumn);
                continue;
            }
            BeanColumn beanColumn2 = new BeanColumn(config.getImplicitNamingStrategy().getColumnName(physicalField.getName()), null, null, false, null, physicalField.getName(), physicalField, propertyDesc.getReadMethod(), propertyDesc.getWriteMethod(), Integer.MAX_VALUE);
            config.getColumnTypeMapping().convertDbTypeByField(beanColumn2);
            if (physicalField.isAnnotationPresent(Version.class)) {
                Version versionAnno = physicalField.getAnnotation(Version.class);
                beanColumn2.setVersion(true);
                beanColumn2.setVersionStrategy(versionAnno.strategy());
                if (this.version) {
                    throw new SqlException("\u5f53\u4e2aPO\u7c7b\u4e2d\u4e50\u89c2\u9501\u5b57\u6bb5\u4e0d\u652f\u6301\u591a\u4e2a!");
                }
                this.version = true;
                this.versionColumn = beanColumn2;
            }
            this.columnsTree.put(beanColumn2.getFieldName(), beanColumn2);
            columnList.add(beanColumn2);
        }
        columnList.sort(new Comparator<BeanColumn>(){

            @Override
            public int compare(BeanColumn o1, BeanColumn o2) {
                return o1.getSort() - o2.getSort();
            }
        });
        this.columns = new ArrayList<BeanColumn>(columnList.size());
        this.columns.addAll(columnList);
        List splitPackage = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)".$")).splitToList((CharSequence)poClazz.getName());
        Entity annotation = poClazz.getAnnotation(Entity.class);
        this.tableName = annotation.tableName() != null && !"".equals(annotation.tableName()) ? annotation.tableName() : config.getImplicitNamingStrategy().getTableName((String)splitPackage.get(splitPackage.size() - 1));
    }

    private PropertyDescriptor getDescriptorByName(@NonNull PropertyDescriptor[] propertyDescriptors, @NonNull String name) {
        if (propertyDescriptors == null) {
            throw new NullPointerException("propertyDescriptors is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!name.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static synchronized BeanWrapper instrance(@NonNull Class<?> poClazz, @NonNull GlobalConfig config) {
        if (poClazz == null) {
            throw new NullPointerException("poClazz is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        BeanWrapper instrance = cacheMap.get(poClazz);
        if (instrance == null) {
            instrance = new BeanWrapper(poClazz, config);
            cacheMap.put(poClazz, instrance);
        }
        return instrance;
    }

    public static synchronized BeanWrapper instrance(@NonNull Class<?> poClazz, @NonNull GlobalConfig config, Map<String, BeanJoin> parentJoinBeans, String tableAliasName, BeanWrapper mainWrapper, BeanWrapper voWrapper) {
        if (poClazz == null) {
            throw new NullPointerException("poClazz is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        BeanWrapper instrance = cacheMap.get(poClazz);
        if (instrance == null) {
            instrance = new BeanWrapper(poClazz, config, parentJoinBeans, tableAliasName, mainWrapper, voWrapper);
            cacheMap.put(poClazz, instrance);
        }
        return instrance;
    }

    public String getSql(String key) {
        return this.sqlCache.get(key);
    }

    public void putSql(String key, String sql) {
        this.sqlCache.put(key, sql);
    }

    public BeanColumn getByPropertyName(@NonNull String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        String[] proSplit = propertyName.split("\\.");
        Map<String, BeanColumn> bufferColumns = null;
        String simplePropertyName = null;
        if (proSplit.length == 1 || proSplit[0].equals(this.tableAliasName)) {
            bufferColumns = this.columnsTree;
            simplePropertyName = propertyName;
        } else {
            @NonNull BeanJoin beanJoin = this.joinBeans.get(proSplit[0]);
            bufferColumns = beanJoin.getJoinBeanWrapper().getColumnsTree();
        }
        return bufferColumns.get(simplePropertyName);
    }

    public String getColumnNameByPropertyName(@NonNull String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        String[] proSplit = propertyName.split("\\.");
        List<BeanColumn> bufferColumns = null;
        String simplePropertyName = null;
        StringBuilder resultName = new StringBuilder();
        if (proSplit.length == 1 || proSplit[0].equals(this.tableAliasName)) {
            if (this.mainWrapper == null) {
                bufferColumns = this.columns;
            } else {
                bufferColumns = this.mainWrapper.columns;
                resultName.append(this.tableAliasName).append(".");
            }
            simplePropertyName = proSplit[proSplit.length - 1];
        } else {
            @NonNull BeanJoin beanJoin = this.joinBeans.get(proSplit[0]);
            bufferColumns = beanJoin.getJoinBeanWrapper().getColumns();
            resultName.append(proSplit[0]).append(".");
            simplePropertyName = proSplit[1];
        }
        for (BeanColumn beanColumn : bufferColumns) {
            if (!beanColumn.getFieldName().equals(simplePropertyName)) continue;
            return resultName.append(beanColumn.getName()).toString();
        }
        return null;
    }

    public static boolean isPo(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Entity entity = clazz.getAnnotation(Entity.class);
        return entity != null;
    }

    public Class<?> getPoClazz() {
        return this.poClazz;
    }

    public void setPoClazz(Class<?> poClazz) {
        this.poClazz = poClazz;
    }

    public BeanColumn getIdColumn() {
        return this.idColumn;
    }

    public List<BeanColumn> getColumns() {
        return this.columns;
    }

    public Map<String, BeanColumn> getColumnsTree() {
        return this.columnsTree;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAliasName() {
        return this.tableAliasName;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public Map<String, BeanJoin> getJoinBeans() {
        return this.joinBeans;
    }

    public BeanWrapper getMainWrapper() {
        return this.mainWrapper;
    }

    public String[] getGroupBys() {
        return this.groupBys;
    }

    public boolean isPageSubSql() {
        return this.pageSubSql;
    }

    public void setPageSubSql(boolean pageSubSql) {
        this.pageSubSql = pageSubSql;
    }

    public BeanWrapper getVoWrapper() {
        return this.voWrapper;
    }

    public List<BeanColumn> getFuncColumns() {
        return this.funcColumns;
    }

    public boolean isVersion() {
        return this.version;
    }

    public BeanColumn getVersionColumn() {
        return this.versionColumn;
    }
}

