/*
 * Decompiled with CFR 0.152.
 */
package com.gugusong.sqlmapper.db.mysql;

import com.google.common.base.Strings;
import com.gugusong.sqlmapper.common.beans.BeanColumn;
import com.gugusong.sqlmapper.db.ColumnTypeMapping;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnTypeMappingImpl
implements ColumnTypeMapping {
    private static final Logger log = LoggerFactory.getLogger(ColumnTypeMappingImpl.class);
    public static final int VAR_DEFAULT_LENGTH = 255;

    @Override
    public void convertDbTypeByField(BeanColumn field) {
        if (Strings.isNullOrEmpty((String)field.getDateType())) {
            field.setDateType(this.mapping(field.getField().getType(), field.getName()));
        }
        if (field.getLength() == null) {
            field.setLength(255);
        }
    }

    private String mapping(Class fieldClazz, String fieldName) {
        if (String.class == fieldClazz) {
            return "VARCHAR";
        }
        if (Date.class == fieldClazz || java.sql.Date.class == fieldClazz) {
            return "DATETIME";
        }
        if (Integer.class == fieldClazz) {
            return "INT";
        }
        if (Integer.TYPE == fieldClazz) {
            log.warn("\u5b57\u6bb5{}\u4e3a\u57fa\u7840\u7c7b\u578b\uff0cbean\u7c7b\u4e2d\u4e0d\u5efa\u8bae\u7528\u57fa\u7840\u7c7b\u578b!", (Object)fieldName);
            return "INT";
        }
        if (Long.class == fieldClazz) {
            return "BIGINT";
        }
        if (Long.TYPE == fieldClazz) {
            log.warn("\u5b57\u6bb5{}\u4e3a\u57fa\u7840\u7c7b\u578b\uff0cbean\u7c7b\u4e2d\u4e0d\u5efa\u8bae\u7528\u57fa\u7840\u7c7b\u578b!", (Object)fieldName);
            return "BIGINT";
        }
        if (Double.class == fieldClazz) {
            return "DOUBLE";
        }
        if (Double.TYPE == fieldClazz) {
            log.warn("\u5b57\u6bb5{}\u4e3a\u57fa\u7840\u7c7b\u578b\uff0cbean\u7c7b\u4e2d\u4e0d\u5efa\u8bae\u7528\u57fa\u7840\u7c7b\u578b!", (Object)fieldName);
            return "DOUBLE";
        }
        if (Float.class == fieldClazz) {
            return "FLOAT";
        }
        if (Float.TYPE == fieldClazz) {
            log.warn("\u5b57\u6bb5{}\u4e3a\u57fa\u7840\u7c7b\u578b\uff0cbean\u7c7b\u4e2d\u4e0d\u5efa\u8bae\u7528\u57fa\u7840\u7c7b\u578b!", (Object)fieldName);
            return "FLOAT";
        }
        if (List.class.isAssignableFrom(fieldClazz)) {
            return "LIST";
        }
        if (Set.class.isAssignableFrom(fieldClazz)) {
            return "SET";
        }
        return "OBJECT";
    }
}

