/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.noisesensors.noisethresholds;

import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsCreateRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsDeleteRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsGetRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsListRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsUpdateRequest;
import com.seam.api.types.NoiseThresholdsCreateResponse;
import com.seam.api.types.NoiseThresholdsDeleteResponse;
import com.seam.api.types.NoiseThresholdsGetResponse;
import com.seam.api.types.NoiseThresholdsListResponse;
import com.seam.api.types.NoiseThresholdsUpdateResponse;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class NoiseThresholdsClient {
    protected final ClientOptions clientOptions;

    public NoiseThresholdsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public NoiseThresholdsCreateResponse create(NoiseThresholdsCreateRequest request) {
        return this.create(request, null);
    }

    public NoiseThresholdsCreateResponse create(NoiseThresholdsCreateRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("noise_sensors/noise_thresholds/create").build();
        HashMap<String, Object> _requestBodyProperties = new HashMap<String, Object>();
        _requestBodyProperties.put("device_id", request.getDeviceId());
        if (request.getSync().isPresent()) {
            _requestBodyProperties.put("sync", request.getSync());
        }
        if (request.getName().isPresent()) {
            _requestBodyProperties.put("name", request.getName());
        }
        _requestBodyProperties.put("starts_daily_at", request.getStartsDailyAt());
        _requestBodyProperties.put("ends_daily_at", request.getEndsDailyAt());
        if (request.getNoiseThresholdDecibels().isPresent()) {
            _requestBodyProperties.put("noise_threshold_decibels", request.getNoiseThresholdDecibels());
        }
        if (request.getNoiseThresholdNrs().isPresent()) {
            _requestBodyProperties.put("noise_threshold_nrs", request.getNoiseThresholdNrs());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (NoiseThresholdsCreateResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), NoiseThresholdsCreateResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NoiseThresholdsDeleteResponse delete(NoiseThresholdsDeleteRequest request) {
        return this.delete(request, null);
    }

    public NoiseThresholdsDeleteResponse delete(NoiseThresholdsDeleteRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("noise_sensors/noise_thresholds/delete").build();
        HashMap<String, Object> _requestBodyProperties = new HashMap<String, Object>();
        _requestBodyProperties.put("noise_threshold_id", request.getNoiseThresholdId());
        _requestBodyProperties.put("device_id", request.getDeviceId());
        if (request.getSync().isPresent()) {
            _requestBodyProperties.put("sync", request.getSync());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (NoiseThresholdsDeleteResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), NoiseThresholdsDeleteResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NoiseThresholdsGetResponse get(NoiseThresholdsGetRequest request) {
        return this.get(request, null);
    }

    public NoiseThresholdsGetResponse get(NoiseThresholdsGetRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("noise_sensors/noise_thresholds/get").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("noise_threshold_id", request.getNoiseThresholdId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (NoiseThresholdsGetResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), NoiseThresholdsGetResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NoiseThresholdsListResponse list(NoiseThresholdsListRequest request) {
        return this.list(request, null);
    }

    public NoiseThresholdsListResponse list(NoiseThresholdsListRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("noise_sensors/noise_thresholds/list").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("device_id", request.getDeviceId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (NoiseThresholdsListResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), NoiseThresholdsListResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NoiseThresholdsUpdateResponse update(NoiseThresholdsUpdateRequest request) {
        return this.update(request, null);
    }

    public NoiseThresholdsUpdateResponse update(NoiseThresholdsUpdateRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("noise_sensors/noise_thresholds/update").build();
        HashMap<String, Object> _requestBodyProperties = new HashMap<String, Object>();
        _requestBodyProperties.put("noise_threshold_id", request.getNoiseThresholdId());
        _requestBodyProperties.put("device_id", request.getDeviceId());
        if (request.getSync().isPresent()) {
            _requestBodyProperties.put("sync", request.getSync());
        }
        if (request.getName().isPresent()) {
            _requestBodyProperties.put("name", request.getName());
        }
        if (request.getStartsDailyAt().isPresent()) {
            _requestBodyProperties.put("starts_daily_at", request.getStartsDailyAt());
        }
        if (request.getEndsDailyAt().isPresent()) {
            _requestBodyProperties.put("ends_daily_at", request.getEndsDailyAt());
        }
        if (request.getNoiseThresholdDecibels().isPresent()) {
            _requestBodyProperties.put("noise_threshold_decibels", request.getNoiseThresholdDecibels());
        }
        if (request.getNoiseThresholdNrs().isPresent()) {
            _requestBodyProperties.put("noise_threshold_nrs", request.getNoiseThresholdNrs());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (NoiseThresholdsUpdateResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), NoiseThresholdsUpdateResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

