/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.UnmanagedDevice;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UnmanagedListResponse {
    private final List<UnmanagedDevice> devices;
    private final boolean ok;

    private UnmanagedListResponse(List<UnmanagedDevice> devices, boolean ok) {
        this.devices = devices;
        this.ok = ok;
    }

    @JsonProperty(value="devices")
    public List<UnmanagedDevice> getDevices() {
        return this.devices;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnmanagedListResponse && this.equalTo((UnmanagedListResponse)other);
    }

    private boolean equalTo(UnmanagedListResponse other) {
        return this.devices.equals(other.devices) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.devices, this.ok);
    }

    public String toString() {
        return "UnmanagedListResponse{devices: " + this.devices + ", ok: " + this.ok + "}";
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private List<UnmanagedDevice> devices = new ArrayList<UnmanagedDevice>();

        private Builder() {
        }

        @Override
        public Builder from(UnmanagedListResponse other) {
            this.devices(other.getDevices());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllDevices(List<UnmanagedDevice> devices) {
            this.devices.addAll(devices);
            return this;
        }

        @Override
        public _FinalStage addDevices(UnmanagedDevice devices) {
            this.devices.add(devices);
            return this;
        }

        @Override
        @JsonSetter(value="devices", nulls=Nulls.SKIP)
        public _FinalStage devices(List<UnmanagedDevice> devices) {
            this.devices.clear();
            this.devices.addAll(devices);
            return this;
        }

        @Override
        public UnmanagedListResponse build() {
            return new UnmanagedListResponse(this.devices, this.ok);
        }
    }

    public static interface _FinalStage {
        public UnmanagedListResponse build();

        public _FinalStage devices(List<UnmanagedDevice> var1);

        public _FinalStage addDevices(UnmanagedDevice var1);

        public _FinalStage addAllDevices(List<UnmanagedDevice> var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(UnmanagedListResponse var1);
    }
}

